/*
 * Vehicle_Plant.c
 *
 * Real-Time Workshop code generation for Simulink model "Vehicle_Plant.mdl".
 *
 * Model Version              : 1.352
 * Real-Time Workshop version : 7.3  (R2009a)  15-Jan-2009
 * C source code generated on : Mon Sep 21 22:57:41 2009
 *
 * Target selection: nidll.tlc
 *   Note: GRT includes extra infrastructure and instrumentation for prototyping
 * Embedded hardware selection: 32-bit Generic
 * Code generation objectives: Unspecified
 * Validation result: Not run
 */

#include "Vehicle_Plant.h"
#include "Vehicle_Plant_private.h"

/* Block signals (auto storage) */
BlockIO_Vehicle_Plant Vehicle_Plant_B;

/* Continuous states */
ContinuousStates_Vehicle_Plant Vehicle_Plant_X;

/* Block states (auto storage) */
D_Work_Vehicle_Plant Vehicle_Plant_DWork;

/* External inputs (root inport signals with auto storage) */
ExternalInputs_Vehicle_Plant Vehicle_Plant_U;

/* External outputs (root outports fed by signals with auto storage) */
ExternalOutputs_Vehicle_Plant Vehicle_Plant_Y;

/* Real-time model */
RT_MODEL_Vehicle_Plant Vehicle_Plant_M_;
RT_MODEL_Vehicle_Plant *Vehicle_Plant_M = &Vehicle_Plant_M_;
real_T Vehicle_Plant_RGND = 0.0;       /* real_T ground */

/*********************************************************************
 * Lookup Binary Search Utility BINARYSEARCH_real_T
 */
void BINARYSEARCH_real_T( uint32_T *piLeft, uint32_T *piRght, real_T u, const
  real_T *pData, uint32_T iHi)
{
  /* Find the location of current input value in the data table. */
  *piLeft = 0;
  *piRght = iHi;
  if (u <= pData[0] ) {
    /* Less than or equal to the smallest point in the table. */
    *piRght = 0;
  } else if (u >= pData[iHi] ) {
    /* Greater than or equal to the largest point in the table. */
    *piLeft = iHi;
  } else {
    uint32_T i;

    /* Do a binary search. */
    while (( *piRght - *piLeft ) > 1 ) {
      /* Get the average of the left and right indices using to Floor rounding. */
      i = (*piLeft + *piRght) >> 1;

      /* Move either the right index or the left index so that */
      /*  LeftDataPoint <= CurrentValue < RightDataPoint */
      if (u < pData[i] ) {
        *piRght = i;
      } else {
        *piLeft = i;
      }
    }
  }
}

/* end macro BINARYSEARCH_real_T
 *********************************************************************/

/*********************************************************************
 * Lookup 2D Lookup Utility Look2D_real_T_real_T_real_T
 */
void Look2D_real_T_real_T_real_T( real_T *pY, const real_T *pYData, real_T u0,
  const real_T *pU0Data, uint32_T iHiU0, real_T u1, const real_T *pU1Data,
  uint32_T iHiU1)
{
  uint32_T iLeftU0, iRghtU0, iLeftU1, iRghtU1;
  BINARYSEARCH_real_T( &(iLeftU0), &(iRghtU0), u0, pU0Data, iHiU0);
  BINARYSEARCH_real_T( &(iLeftU1), &(iRghtU1), u1, pU1Data, iHiU1);

  {
    real_T u0Left = pU0Data[iLeftU0];
    real_T u0Rght = pU0Data[iRghtU0];
    real_T u1Left = pU1Data[iLeftU1];
    real_T u1Rght = pU1Data[iRghtU1];
    real_T yTemp;
    real_T yLeftLeft;
    real_T yLeftRght;
    real_T yRghtLeft;
    real_T yRghtRght;
    real_T u1Lambda;
    real_T u0Lambda;
    if (u1Rght > u1Left ) {
      real_T num;
      real_T den;
      den = u1Rght;
      den = den - u1Left;
      num = u1;
      num = num - u1Left;
      u1Lambda = num / den;
    } else {
      u1Lambda = 0;
    }

    if (u0Rght > u0Left ) {
      real_T num;
      real_T den;
      den = u0Rght;
      den = den - u0Left;
      num = u0;
      num = num - u0Left;
      u0Lambda = num / den;
    } else {
      u0Lambda = 0;
    }

    iHiU0++;
    iLeftU1 *= iHiU0;
    iRghtU1 *= iHiU0;
    yRghtLeft = pYData[(iRghtU0+iLeftU1)];
    yRghtRght = pYData[(iRghtU0+iRghtU1)];
    yLeftLeft = pYData[(iLeftU0+iLeftU1)];
    yLeftRght = pYData[(iLeftU0+iRghtU1)];

    /* Interpolate along U1 variable
     *    with the u0 variable locked on the left u0
     */
    {
      real_T yLeftCast;
      real_T yRghtCast;
      yLeftCast = yLeftLeft;
      yRghtCast = yLeftRght;
      if (u1Lambda != 0) {
        yLeftCast += u1Lambda * ( yRghtCast - yLeftCast );
      }

      (*pY) = yLeftCast;
    }

    /* Interpolate along U1 variable
     *    with the u0 variable locked on the right u0
     */
    {
      real_T yLeftCast;
      real_T yRghtCast;
      yLeftCast = yRghtLeft;
      yRghtCast = yRghtRght;
      if (u1Lambda != 0) {
        yLeftCast += u1Lambda * ( yRghtCast - yLeftCast );
      }

      yTemp = yLeftCast;
    }

    /*
     * Interpolate along u0 variable
     *    with the u1 variable locked on its interpolated value
     */
    {
      real_T yLeftCast;
      real_T yRghtCast;
      yLeftCast = (*pY);
      yRghtCast = yTemp;
      if (u0Lambda != 0) {
        yLeftCast += u0Lambda * ( yRghtCast - yLeftCast );
      }

      (*pY) = yLeftCast;
    }
  }
}

/* end function Look2D_real_T_real_T_real_T
 *********************************************************************/

/*********************************************************************
 * Lookup Utility LookUp_real_T_real_T
 */
void LookUp_real_T_real_T( real_T *pY, const real_T *pYData, real_T u, const
  real_T *pUData, uint32_T iHi)
{
  uint32_T iLeft;
  uint32_T iRght;
  BINARYSEARCH_real_T( &(iLeft), &(iRght), u, pUData, iHi);

  {
    real_T lambda;
    if (pUData[iRght] > pUData[iLeft] ) {
      real_T num;
      real_T den;
      den = pUData[iRght];
      den = den - pUData[iLeft];
      num = u;
      num = num - pUData[iLeft];
      lambda = num / den;
    } else {
      lambda = 0;
    }

    {
      real_T yLeftCast;
      real_T yRghtCast;
      yLeftCast = pYData[iLeft];
      yRghtCast = pYData[iRght];
      if (lambda != 0) {
        yLeftCast += lambda * ( yRghtCast - yLeftCast );
      }

      (*pY) = yLeftCast;
    }
  }
}

/* end function LookUp_real_T_real_T
 *********************************************************************/

/* Projection for root system: '<Root>' */
void Vehicle_Plant_projection(void)
{
  /* S-Function Block: <S42>/Parameter Block */
  {
  }

  /* S-Function Block: <S42>/Kinematic Block */
  {
    DriveSimulationData *_simdata = NULL;
    _simdata = (DriveSimulationData *) Vehicle_Plant_DWork.KinematicBlock_PWORK;
    _simdata->driveLine->time = Vehicle_Plant_M->Timing.t[0];
    _simdata->driveLine->ismajortimestep = rtmIsMajorTimeStep(Vehicle_Plant_M);
    if (driveKinematicSfcnProjection(_simdata)) {
      memcpy(_simdata->driveLine->engineError, driveGetErrorMsg(), sizeof
             (DriveErrorRecord));
      _simdata->driveLine->engineError->errorFlag = true;
      rtmSetErrorStatus(Vehicle_Plant_M, _simdata->driveLine->
                        engineError->errorMsg);
      return;
    }
  }

  /* S-Function Block: <S42>/Dynamic Block */
  {
  }

  /* S-Function Block: <S42>/Event Block */
  {
  }
}

/* This function updates continuous states using the ODE4 fixed-step
 * solver algorithm
 */
static void rt_ertODEUpdateContinuousStates(RTWSolverInfo *si )
{
  time_T t = rtsiGetT(si);
  time_T tnew = rtsiGetSolverStopTime(si);
  time_T h = rtsiGetStepSize(si);
  real_T *x = rtsiGetContStates(si);
  ODE4_IntgData *id = (ODE4_IntgData *)rtsiGetSolverData(si);
  real_T *y = id->y;
  real_T *f0 = id->f[0];
  real_T *f1 = id->f[1];
  real_T *f2 = id->f[2];
  real_T *f3 = id->f[3];
  real_T temp;
  int_T i;
  int_T nXc = 12;
  rtsiSetSimTimeStep(si,MINOR_TIME_STEP);

  /* Save the state values at time t in y, we'll use x as ynew. */
  (void) memcpy(y,x,
                nXc*sizeof(real_T));

  /* Assumes that rtsiSetT and ModelOutputs are up-to-date */
  /* f0 = f(t,y) */
  rtsiSetdX(si, f0);
  Vehicle_Plant_derivatives();

  /* f1 = f(t + (h/2), y + (h/2)*f0) */
  temp = 0.5 * h;
  for (i = 0; i < nXc; i++)
    x[i] = y[i] + (temp*f0[i]);
  rtsiSetT(si, t + temp);
  rtsiSetdX(si, f1);
  Vehicle_Plant_output(0);
  Vehicle_Plant_derivatives();

  /* f2 = f(t + (h/2), y + (h/2)*f1) */
  for (i = 0; i < nXc; i++)
    x[i] = y[i] + (temp*f1[i]);
  rtsiSetdX(si, f2);
  Vehicle_Plant_output(0);
  Vehicle_Plant_derivatives();

  /* f3 = f(t + h, y + h*f2) */
  for (i = 0; i < nXc; i++)
    x[i] = y[i] + (h*f2[i]);
  rtsiSetT(si, tnew);
  rtsiSetdX(si, f3);
  Vehicle_Plant_output(0);
  Vehicle_Plant_derivatives();

  /* tnew = t + h
     ynew = y + (h/6)*(f0 + 2*f1 + 2*f2 + 2*f3) */
  temp = h / 6.0;
  for (i = 0; i < nXc; i++) {
    x[i] = y[i] + temp*(f0[i] + 2.0*f1[i] + 2.0*f2[i] + f3[i]);
  }

  Vehicle_Plant_output(0);
  Vehicle_Plant_projection();
  rtsiSetSimTimeStep(si,MAJOR_TIME_STEP);
}

/* Model output function */
void Vehicle_Plant_output(int_T tid)
{
  /* local block i/o variables */
  real_T rtb_radtorpm;
  real_T rtb_Abs1;
  real_T rtb_LookupTable2D;
  real_T rtb_Abs;
  real_T rtb_Abs1_n;
  real_T rtb_LookupTable2D_e;
  real_T rtb_Abs_p;
  real_T rtb_Switch;
  real_T rtb_mstomph;
  real_T rtb_BrakeTorqueMap;
  real_T rtb_GainV_l;
  real_T rtb_mstomph_l;
  real_T rtb_BrakeTorqueMap_j;
  real_T rtb_GainV_e;
  real_T rtb_EngineTorqueData;
  real_T rtb_Fuel_Rate;
  real_T rtb_Gain1;
  real_T rtb_TransferFcn1;

  /* Update absolute time of base rate at minor time step */
  if (rtmIsMinorTimeStep(Vehicle_Plant_M)) {
    Vehicle_Plant_M->Timing.t[0] = rtsiGetT(&Vehicle_Plant_M->solverInfo);
  }

  if (rtmIsMajorTimeStep(Vehicle_Plant_M)) {
    /* set solver stop time */
    rtsiSetSolverStopTime(&Vehicle_Plant_M->solverInfo,
                          ((Vehicle_Plant_M->Timing.clockTick0+1)*
      Vehicle_Plant_M->Timing.stepSize0));
  }                                    /* end MajorTimeStep */

  {
    real_T rtb_Product_hc;
    real_T rtb_Sum2;
    real_T rtb_Product_g;
    real_T rtb_Product_n;
    real_T rtb_Frontalarea;
    real_T rtb_Sum1_i;

    /* Integrator: '<S64>/integrator' */
    rtb_Gain1 = Vehicle_Plant_X.integrator_CSTATE;

    /* Integrator: '<S32>/Integrator' */
    Vehicle_Plant_B.Integrator = Vehicle_Plant_X.Integrator_CSTATE;

    /* Gain: '<S35>/Gain1' */
    Vehicle_Plant_B.Gain1 = Vehicle_Plant_P.Gain1_Gain *
      Vehicle_Plant_B.Integrator;

    /* Gain: '<S34>/Gain1' */
    Vehicle_Plant_B.Gain1_b = Vehicle_Plant_P.Gain1_Gain_e *
      Vehicle_Plant_B.Integrator;

    /* SignalConversion: '<S42>/TmpHiddenBufferAtKinematic BlockInport2' incorporates:
     *  Constant: '<S34>/Constant2'
     *  Constant: '<S35>/Constant2'
     *  Integrator: '<S60>/integrator'
     */
    Vehicle_Plant_B.TmpHiddenBufferAtKinematicBlock[0] = rtb_Gain1;
    Vehicle_Plant_B.TmpHiddenBufferAtKinematicBlock[1] = Vehicle_Plant_B.Gain1;
    Vehicle_Plant_B.TmpHiddenBufferAtKinematicBlock[2] =
      Vehicle_Plant_P.Constant2_Value;
    Vehicle_Plant_B.TmpHiddenBufferAtKinematicBlock[3] =
      Vehicle_Plant_X.integrator_CSTATE_k;
    Vehicle_Plant_B.TmpHiddenBufferAtKinematicBlock[4] = Vehicle_Plant_B.Gain1_b;
    Vehicle_Plant_B.TmpHiddenBufferAtKinematicBlock[5] =
      Vehicle_Plant_P.Constant2_Value_g;

    /* SignalConversion: '<S42>/TmpHiddenBufferAtParameter BlockInport1' incorporates:
     *  Constant: '<S10>/Inertia'
     *  Constant: '<S10>/InitialCondition'
     *  Constant: '<S16>/Inertia'
     *  Constant: '<S16>/InitialCondition'
     *  Constant: '<S21>/Inertia'
     *  Constant: '<S21>/InitialCondition'
     *  Constant: '<S29>/Inertia'
     *  Constant: '<S29>/InitialCondition'
     *  Constant: '<S33>/Inertia'
     *  Constant: '<S33>/InitialCondition'
     *  Constant: '<S36>/PlanetPlanetRatio'
     *  Constant: '<S37>/PlanetPlanetRatio'
     *  Constant: '<S38>/GearRatio'
     *  Constant: '<S39>/GearRatio'
     *  Constant: '<S40>/GearRatio'
     *  Constant: '<S41>/GearRatio'
     */
    Vehicle_Plant_B.TmpHiddenBufferAtParameterBlock[0] =
      Vehicle_Plant_P.Inertia_Value;
    Vehicle_Plant_B.TmpHiddenBufferAtParameterBlock[1] =
      Vehicle_Plant_P.InitialCondition_Value;
    Vehicle_Plant_B.TmpHiddenBufferAtParameterBlock[2] =
      Vehicle_Plant_P.GearRatio_Value;
    Vehicle_Plant_B.TmpHiddenBufferAtParameterBlock[3] =
      Vehicle_Plant_P.PlanetPlanetRatio_Value;
    Vehicle_Plant_B.TmpHiddenBufferAtParameterBlock[4] =
      Vehicle_Plant_P.PlanetPlanetRatio_Value_d;
    Vehicle_Plant_B.TmpHiddenBufferAtParameterBlock[5] =
      Vehicle_Plant_P.GearRatio_Value_d;
    Vehicle_Plant_B.TmpHiddenBufferAtParameterBlock[6] =
      Vehicle_Plant_P.GearRatio_Value_l;
    Vehicle_Plant_B.TmpHiddenBufferAtParameterBlock[7] =
      Vehicle_Plant_P.Inertia_Value_i;
    Vehicle_Plant_B.TmpHiddenBufferAtParameterBlock[8] =
      Vehicle_Plant_P.InitialCondition_Value_m;
    Vehicle_Plant_B.TmpHiddenBufferAtParameterBlock[9] =
      Vehicle_Plant_P.GearRatio_Value_j;
    Vehicle_Plant_B.TmpHiddenBufferAtParameterBlock[10] =
      Vehicle_Plant_P.Inertia_Value_k;
    Vehicle_Plant_B.TmpHiddenBufferAtParameterBlock[11] =
      Vehicle_Plant_P.InitialCondition_Value_b;
    Vehicle_Plant_B.TmpHiddenBufferAtParameterBlock[12] =
      Vehicle_Plant_P.Inertia_Value_a;
    Vehicle_Plant_B.TmpHiddenBufferAtParameterBlock[13] =
      Vehicle_Plant_P.InitialCondition_Value_e;
    Vehicle_Plant_B.TmpHiddenBufferAtParameterBlock[14] =
      Vehicle_Plant_P.Inertia_Value_b;
    Vehicle_Plant_B.TmpHiddenBufferAtParameterBlock[15] =
      Vehicle_Plant_P.InitialCondition_Value_a;

    /* S-Function Block: <S42>/Parameter Block */
    {
      DriveSimulationData *_simdata = NULL;
      _simdata = (DriveSimulationData *)
        Vehicle_Plant_DWork.ParameterBlock_PWORK;
      _simdata->driveLine->time = Vehicle_Plant_M->Timing.t[0];
      _simdata->driveLine->ismajortimestep = rtmIsMajorTimeStep(Vehicle_Plant_M);
      if (driveParameterSfcnOutputs(_simdata)) {
        memcpy(_simdata->driveLine->engineError, driveGetErrorMsg(), sizeof
               (DriveErrorRecord));
        _simdata->driveLine->engineError->errorFlag = true;
        rtmSetErrorStatus(Vehicle_Plant_M, _simdata->driveLine->
                          engineError->errorMsg);
        return;
      }
    }

    /* S-Function Block: <S42>/Kinematic Block */
    {
      DriveSimulationData *_simdata = NULL;
      _simdata = (DriveSimulationData *)
        Vehicle_Plant_DWork.KinematicBlock_PWORK;
      _simdata->driveLine->time = Vehicle_Plant_M->Timing.t[0];
      _simdata->driveLine->ismajortimestep = rtmIsMajorTimeStep(Vehicle_Plant_M);
      if (driveKinematicSfcnOutputs(_simdata)) {
        memcpy(_simdata->driveLine->engineError, driveGetErrorMsg(), sizeof
               (DriveErrorRecord));
        _simdata->driveLine->engineError->errorFlag = true;
        rtmSetErrorStatus(Vehicle_Plant_M, _simdata->driveLine->
                          engineError->errorMsg);
        return;
      }
    }

    /* Gain: '<S5>/rad to rpm' incorporates:
     *  Gain: '<S17>/Gain V'
     */
    rtb_radtorpm = Vehicle_Plant_P.GainV_Gain *
      Vehicle_Plant_B.KinematicBlock_o4[1] * Vehicle_Plant_P.radtorpm_Gain;

    /* Outport: '<Root>/Measured_Engine_rpm' */
    Vehicle_Plant_Y.Measured_Engine_rpm = rtb_radtorpm;

    /* Sum: '<S3>/Sum2' incorporates:
     *  Constant: '<S3>/Constant2'
     *  Constant: '<S3>/Constant3'
     *  Gain: '<S3>/Gain'
     *  Integrator: '<S3>/Integrator'
     *  Product: '<S3>/Divide'
     */
    rtb_Sum2 = Vehicle_Plant_P.Gain_Gain * Vehicle_Plant_X.Integrator_CSTATE_h /
      Vehicle_Plant_P.Constant2_Value_a + Vehicle_Plant_P.Constant3_Value;

    /* Outport: '<Root>/Battery_SOC' */
    Vehicle_Plant_Y.Battery_SOC = rtb_Sum2;

    /* Gain: '<S23>/Gain V' */
    rtb_Product_hc = Vehicle_Plant_P.GainV_Gain_b *
      Vehicle_Plant_B.KinematicBlock_o4[2];

    /* Gain: '<S6>/Gain1' */
    rtb_Gain1 = Vehicle_Plant_P.Gain1_Gain_o * rtb_Product_hc;

    /* Abs: '<S6>/Abs1' */
    rtb_Abs1 = fabs(rtb_Gain1);
    if (rtmIsMajorTimeStep(Vehicle_Plant_M)) {
      /* Memory: '<S6>/Memory' */
      Vehicle_Plant_B.Memory = Vehicle_Plant_DWork.Memory_PreviousInput;
    }

    /* Lookup2D Block: '<S6>/Lookup Table (2-D)'
     * About '<S6>/Lookup Table (2-D) :'
     * Lookup2D Block: '<S6>/Lookup Table (2-D)'
     * Input0  Data Type:  Floating Point real_T
     * Input1  Data Type:  Floating Point real_T
     * Output0 Data Type:  Floating Point real_T
     * Lookup Method: Linear_Endpoint
     *
     * Row Data    parameter uses the same data type and scaling as Input0
     * Column Data parameter uses the same data type and scaling as Input1
     * Table Data  parameter uses the same data type and scaling as Output0


     */
    Look2D_real_T_real_T_real_T( &(rtb_LookupTable2D),
      Vehicle_Plant_P.LookupTable2D_Table, rtb_Abs1,
      Vehicle_Plant_P.LookupTable2D_RowIdx, 20U, Vehicle_Plant_B.Memory,
      Vehicle_Plant_P.LookupTable2D_ColIdx, 9U);

    /* Abs: '<S6>/Abs' */
    rtb_Abs = fabs(rtb_Gain1);

    /* Lookup Block: '<S6>/Lookup Table'
     * About '<S6>/Lookup Table :'
     * Lookup Block: '<S6>/Lookup Table'
     * Input0  Data Type:  Floating Point real_T
     * Output0 Data Type:  Floating Point real_T
     * Lookup Method: Linear_Endpoint
     *
     * XData parameter uses the same data type and scaling as Input0
     * YData parameter uses the same data type and scaling as Output0


     */
    LookUp_real_T_real_T( &(rtb_Gain1), Vehicle_Plant_P.LookupTable_YData,
                         rtb_Abs, Vehicle_Plant_P.LookupTable_XData, 15U);
    if (rtmIsMajorTimeStep(Vehicle_Plant_M)) {
      /* Memory: '<S6>/Memory1' */
      Vehicle_Plant_B.Memory1 = Vehicle_Plant_DWork.Memory1_PreviousInput;

      /* Memory: '<S3>/Memory' */
      Vehicle_Plant_B.Memory_f = Vehicle_Plant_DWork.Memory_PreviousInput_n;

      /* Memory: '<S3>/Memory1' */
      Vehicle_Plant_B.Memory1_g = Vehicle_Plant_DWork.Memory1_PreviousInput_k;
    }

    /* Switch: '<S3>/Switch1' incorporates:
     *  Constant: '<S3>/Constant1'
     *  Saturate: '<S3>/Saturation'
     */
    if (Vehicle_Plant_B.Memory1_g >= Vehicle_Plant_P.Switch1_Threshold) {
      /* Switch: '<S3>/Switch' incorporates:
       *  Constant: '<S3>/Battery Temperature'
       *  Lookup2D: '<S3>/Charge  Resistance'
       *  Lookup2D: '<S3>/Discharge  Resistance'
       */
      if (Vehicle_Plant_B.Memory_f >= Vehicle_Plant_P.Switch_Threshold_f) {
        rtb_Sum1_i = rt_Lookup2D_Normal((const real_T *)
          (&Vehicle_Plant_P.ChargeResistance_RowIdx[0]), 9, (const real_T *)
          (&Vehicle_Plant_P.ChargeResistance_ColIdx[0]), 5, (const real_T *)
          (&Vehicle_Plant_P.ChargeResistance_Table[0]), (const real_T)rtb_Sum2,
                                        (const real_T)
          Vehicle_Plant_P.BatteryTemperature_Value);
      } else {
        rtb_Sum1_i = rt_Lookup2D_Normal((const real_T *)
          (&Vehicle_Plant_P.DischargeResistance_RowIdx[0]), 9, (const real_T *)(
          &Vehicle_Plant_P.DischargeResistance_ColIdx[0]), 5, (const real_T *)
          (&Vehicle_Plant_P.DischargeResistance_Table[0]), (const real_T)
          rtb_Sum2, (const real_T)Vehicle_Plant_P.BatteryTemperature_Value);
      }

      /* Sum: '<S3>/Sum1' incorporates:
       *  Constant: '<S3>/Battery Temperature1'
       *  Lookup2D: '<S3>/Battery OCV'
       *  Product: '<S3>/Product'
       */
      rtb_Sum1_i = rtb_Sum1_i * Vehicle_Plant_B.Memory_f + rt_Lookup2D_Normal((
        const real_T *)(&Vehicle_Plant_P.BatteryOCV_RowIdx[0]), 9, (const real_T
        *)(&Vehicle_Plant_P.BatteryOCV_ColIdx[0]), 5, (const real_T *)
        (&Vehicle_Plant_P.BatteryOCV_Table[0]), (const real_T)rtb_Sum2, (const
        real_T)Vehicle_Plant_P.BatteryTemperature1_Value);
      rtb_Frontalarea = rt_SATURATE(rtb_Sum1_i,
        Vehicle_Plant_P.Saturation_LowerSat, Vehicle_Plant_P.Saturation_UpperSat);
    } else {
      rtb_Frontalarea = Vehicle_Plant_P.Constant1_Value;
    }

    /* Switch: '<S6>/Switch1' incorporates:
     *  Constant: '<S6>/Constant1'
     */
    if (rtb_Frontalarea >= Vehicle_Plant_P.Switch1_Threshold_o) {
      rtb_Product_g = Vehicle_Plant_B.Memory1;
    } else {
      rtb_Product_g = Vehicle_Plant_P.Constant1_Value_n;
    }

    /* Product: '<S6>/Product' incorporates:
     *  Constant: '<S6>/Constant'
     *  Inport: '<Root>/Generator_Torque'
     *  Product: '<S6>/Product3'
     */
    rtb_Product_n = Vehicle_Plant_U.Generator_Torque * rtb_Product_g *
      Vehicle_Plant_P.Constant_Value;

    /* MinMax: '<S6>/MinMax' */
    Vehicle_Plant_B.MinMax = rt_MINd_snf(rtb_Gain1, rtb_Product_n);

    /* Product: '<S6>/Product1' */
    rtb_Sum1_i = rtb_Product_hc * Vehicle_Plant_B.MinMax;

    /* Switch: '<S6>/Switch' incorporates:
     *  Product: '<S6>/Divide1'
     *  Product: '<S6>/Product2'
     */
    if (rtb_Sum1_i >= Vehicle_Plant_P.Switch_Threshold) {
      rtb_Product_n = 1.0 / rtb_LookupTable2D * rtb_Sum1_i;
    } else {
      rtb_Product_n = rtb_Sum1_i * rtb_LookupTable2D;
    }

    /* Gain: '<S6>/Gain' incorporates:
     *  Product: '<S6>/Divide'
     */
    rtb_Product_n = rtb_Product_n / rtb_Frontalarea *
      Vehicle_Plant_P.Gain_Gain_n;

    /* Outport: '<Root>/Generator_Current_A' */
    Vehicle_Plant_Y.Generator_Current_A = rtb_Product_n;
    if (rtmIsMajorTimeStep(Vehicle_Plant_M)) {
      /* Switch: '<S3>/Switch3' incorporates:
       *  Constant: '<S3>/Constant8'
       */
      if (Vehicle_Plant_B.Memory1_g >= Vehicle_Plant_P.Switch3_Threshold) {
        /* Switch: '<S3>/Switch2' incorporates:
         *  Constant: '<S3>/Constant6'
         *  Constant: '<S3>/Constant7'
         */
        if (Vehicle_Plant_B.Memory1_g >= Vehicle_Plant_P.Switch2_Threshold_b) {
          rtb_Sum1_i = Vehicle_Plant_P.Constant6_Value;
        } else {
          rtb_Sum1_i = Vehicle_Plant_P.Constant7_Value;
        }
      } else {
        rtb_Sum1_i = Vehicle_Plant_P.Constant8_Value;
      }

      /* Outport: '<Root>/Battery_Pack_State' */
      Vehicle_Plant_Y.Battery_Pack_State = rtb_Sum1_i;

      /* Memory: '<S4>/Memory1' */
      Vehicle_Plant_B.Memory1_j = Vehicle_Plant_DWork.Memory1_PreviousInput_j;
    }

    /* Switch: '<S4>/Switch1' incorporates:
     *  Constant: '<S4>/Constant1'
     */
    if (rtb_Frontalarea >= Vehicle_Plant_P.Switch1_Threshold_e) {
      rtb_Product_hc = Vehicle_Plant_B.Memory1_j;
    } else {
      rtb_Product_hc = Vehicle_Plant_P.Constant1_Value_b;
    }

    /* Outport: '<Root>/Motor_State' */
    Vehicle_Plant_Y.Motor_State = rtb_Product_hc;

    /* Outport: '<Root>/Gen_State' */
    Vehicle_Plant_Y.Gen_State = rtb_Product_g;

    /* Gain: '<S12>/Gain V' */
    rtb_Product_g = Vehicle_Plant_P.GainV_Gain_h *
      Vehicle_Plant_B.KinematicBlock_o4[3];

    /* Gain: '<S4>/Gain1' */
    rtb_Gain1 = Vehicle_Plant_P.Gain1_Gain_k * rtb_Product_g;

    /* Abs: '<S4>/Abs1' */
    rtb_Abs1_n = fabs(rtb_Gain1);
    if (rtmIsMajorTimeStep(Vehicle_Plant_M)) {
      /* Memory: '<S4>/Memory' */
      Vehicle_Plant_B.Memory_k = Vehicle_Plant_DWork.Memory_PreviousInput_m;
    }

    /* Lookup2D Block: '<S4>/Lookup Table (2-D)'
     * About '<S4>/Lookup Table (2-D) :'
     * Lookup2D Block: '<S4>/Lookup Table (2-D)'
     * Input0  Data Type:  Floating Point real_T
     * Input1  Data Type:  Floating Point real_T
     * Output0 Data Type:  Floating Point real_T
     * Lookup Method: Linear_Endpoint
     *
     * Row Data    parameter uses the same data type and scaling as Input0
     * Column Data parameter uses the same data type and scaling as Input1
     * Table Data  parameter uses the same data type and scaling as Output0


     */
    Look2D_real_T_real_T_real_T( &(rtb_LookupTable2D_e),
      Vehicle_Plant_P.LookupTable2D_Table_c, rtb_Abs1_n,
      Vehicle_Plant_P.LookupTable2D_RowIdx_n, 20U, Vehicle_Plant_B.Memory_k,
      Vehicle_Plant_P.LookupTable2D_ColIdx_l, 9U);

    /* Abs: '<S4>/Abs' */
    rtb_Abs_p = fabs(rtb_Gain1);

    /* Lookup Block: '<S4>/Lookup Table'
     * About '<S4>/Lookup Table :'
     * Lookup Block: '<S4>/Lookup Table'
     * Input0  Data Type:  Floating Point real_T
     * Output0 Data Type:  Floating Point real_T
     * Lookup Method: Linear_Endpoint
     *
     * XData parameter uses the same data type and scaling as Input0
     * YData parameter uses the same data type and scaling as Output0


     */
    LookUp_real_T_real_T( &(rtb_TransferFcn1),
                         Vehicle_Plant_P.LookupTable_YData_p, rtb_Abs_p,
                         Vehicle_Plant_P.LookupTable_XData_o, 15U);

    /* Product: '<S4>/Product' incorporates:
     *  Constant: '<S4>/Constant'
     *  Inport: '<Root>/Motor_torque_Request'
     *  Product: '<S4>/Product3'
     */
    rtb_Product_hc = Vehicle_Plant_U.Motor_Torque_Request * rtb_Product_hc *
      Vehicle_Plant_P.Constant_Value_n;

    /* MinMax: '<S4>/MinMax' */
    Vehicle_Plant_B.MinMax_c = rt_MINd_snf(rtb_TransferFcn1, rtb_Product_hc);

    /* Product: '<S4>/Product1' */
    rtb_Sum1_i = rtb_Product_g * Vehicle_Plant_B.MinMax_c;

    /* Switch: '<S4>/Switch' incorporates:
     *  Product: '<S4>/Divide1'
     *  Product: '<S4>/Product2'
     */
    if (rtb_Sum1_i >= Vehicle_Plant_P.Switch_Threshold_i) {
      rtb_TransferFcn1 = 1.0 / rtb_LookupTable2D_e * rtb_Sum1_i;
    } else {
      rtb_TransferFcn1 = rtb_Sum1_i * rtb_LookupTable2D_e;
    }

    /* Gain: '<S4>/Gain' incorporates:
     *  Product: '<S4>/Divide'
     */
    rtb_TransferFcn1 = rtb_TransferFcn1 / rtb_Frontalarea *
      Vehicle_Plant_P.Gain_Gain_p;

    /* Outport: '<Root>/Motor_Current_A' */
    Vehicle_Plant_Y.Motor_Current_A = rtb_TransferFcn1;

    /* Outport: '<Root>/Motor_rpm' */
    Vehicle_Plant_Y.Motor_rpm = rtb_Gain1;
    if (rtmIsMajorTimeStep(Vehicle_Plant_M)) {
      /* Gain: '<S1>/Battery_Current' */
      Vehicle_Plant_B.Battery_Current = Vehicle_Plant_P.Battery_Current_Gain *
        Vehicle_Plant_B.Memory_f;
    }

    /* Gain: '<S1>/Battery_SOC' */
    Vehicle_Plant_B.Battery_SOC = Vehicle_Plant_P.Battery_SOC_Gain * rtb_Sum2;

    /* Gain: '<S1>/Battery_Voltage' */
    Vehicle_Plant_B.Battery_Voltage = Vehicle_Plant_P.Battery_Voltage_Gain *
      rtb_Frontalarea;

    /* Gain: '<S1>/Engine_rpm' */
    Vehicle_Plant_B.Engine_rpm = Vehicle_Plant_P.Engine_rpm_Gain * rtb_radtorpm;

    /* Gain: '<S1>/Generator_Current' */
    Vehicle_Plant_B.Generator_Current = Vehicle_Plant_P.Generator_Current_Gain *
      rtb_Product_n;

    /* Gain: '<S1>/Motor_Current' */
    Vehicle_Plant_B.Motor_Current = Vehicle_Plant_P.Motor_Current_Gain *
      rtb_TransferFcn1;

    /* Gain: '<S1>/Vehicle_Speed_mph' incorporates:
     *  Gain: '<S7>/Gain3'
     */
    Vehicle_Plant_B.Vehicle_Speed_mph = Vehicle_Plant_P.Gain3_Gain *
      Vehicle_Plant_B.Integrator * Vehicle_Plant_P.Vehicle_Speed_mph_Gain;
    if (rtmIsMajorTimeStep(Vehicle_Plant_M)) {
      /* Gain: '<S1>/Time' incorporates:
       *  DiscreteIntegrator: '<S1>/Discrete-Time Integrator'
       */
      Vehicle_Plant_B.Time = Vehicle_Plant_P.Time_Gain *
        Vehicle_Plant_DWork.DiscreteTimeIntegrator_DSTATE;
    }

    /* RateLimiter: '<S3>/Rate Limiter' incorporates:
     *  Inport: '<Root>/Battery_Connect_Command'
     */
    if (Vehicle_Plant_DWork.LastMajorTime == (rtInf)) {
      Vehicle_Plant_B.RateLimiter = Vehicle_Plant_U.Battery_Connect_Command;
    } else {
      rtb_Sum1_i = Vehicle_Plant_M->Timing.t[0] -
        Vehicle_Plant_DWork.LastMajorTime;
      rtb_Product_hc = rtb_Sum1_i * Vehicle_Plant_P.RateLimiter_RisingLim;
      rtb_Product_g = Vehicle_Plant_U.Battery_Connect_Command -
        Vehicle_Plant_DWork.PrevY;
      if (rtb_Product_g > rtb_Product_hc) {
        Vehicle_Plant_B.RateLimiter = Vehicle_Plant_DWork.PrevY + rtb_Product_hc;
      } else {
        rtb_Sum1_i *= Vehicle_Plant_P.RateLimiter_FallingLim;
        if (rtb_Product_g < rtb_Sum1_i) {
          Vehicle_Plant_B.RateLimiter = Vehicle_Plant_DWork.PrevY + rtb_Sum1_i;
        } else {
          Vehicle_Plant_B.RateLimiter = Vehicle_Plant_U.Battery_Connect_Command;
        }
      }
    }

    /* Switch: '<S9>/SwitchControl' incorporates:
     *  Constant: '<S3>/Constant4'
     *  Constant: '<S9>/Constant'
     */
    if (Vehicle_Plant_P.Constant_Value_d >
        Vehicle_Plant_P.SwitchControl_Threshold) {
      Vehicle_Plant_B.SwitchControl = Vehicle_Plant_B.RateLimiter;
    } else {
      Vehicle_Plant_B.SwitchControl = Vehicle_Plant_P.Constant4_Value;
    }

    /* Sum: '<S3>/Sum' */
    Vehicle_Plant_B.Sum = rtb_TransferFcn1 + rtb_Product_n;
    if (rtmIsMajorTimeStep(Vehicle_Plant_M)) {
    }

    /* Abs: '<S4>/Abs2' */
    Vehicle_Plant_B.Abs2 = fabs(rtb_TransferFcn1);
    if (rtmIsMajorTimeStep(Vehicle_Plant_M)) {
      /* Switch: '<S11>/SwitchControl' incorporates:
       *  Constant: '<S11>/Constant'
       *  Constant: '<S4>/Constant2'
       *  Inport: '<Root>/Motor_Enable'
       */
      if (Vehicle_Plant_P.Constant_Value_p >
          Vehicle_Plant_P.SwitchControl_Threshold_b) {
        Vehicle_Plant_B.SwitchControl_j = Vehicle_Plant_U.Motor_Enable;
      } else {
        Vehicle_Plant_B.SwitchControl_j = Vehicle_Plant_P.Constant2_Value_o;
      }
    }

    /* Switch: '<S5>/Switch' incorporates:
     *  Constant: '<S5>/Throttle1'
     *  Inport: '<Root>/Engine_Throttle'
     *  Saturate: '<S5>/Saturation'
     */
    if (rtb_radtorpm >= Vehicle_Plant_P.Switch_Threshold_n) {
      rtb_Switch = Vehicle_Plant_P.Throttle1_Value;
    } else {
      rtb_Switch = rt_SATURATE(Vehicle_Plant_U.Engine_Throttle,
        Vehicle_Plant_P.Saturation_LowerSat_b,
        Vehicle_Plant_P.Saturation_UpperSat_k);
    }

    /* Integrator: '<S5>/Integrator' */
    rtb_TransferFcn1 = Vehicle_Plant_X.Integrator_CSTATE_e;

    /* Switch: '<S5>/Switch1' incorporates:
     *  Constant: '<S5>/Throttle2'
     *  Inport: '<Root>/Engine_On'
     *  Lookup2D: '<S5>/Engine Torque Data'
     */
    if (Vehicle_Plant_U.Engine_On >= Vehicle_Plant_P.Switch1_Threshold_n) {
      /* Lookup2D Block: '<S5>/Engine Torque Data'
       * About '<S5>/Engine Torque Data :'
       * Lookup2D Block: '<S5>/Engine Torque Data'
       * Input0  Data Type:  Floating Point real_T
       * Input1  Data Type:  Floating Point real_T
       * Output0 Data Type:  Floating Point real_T
       * Lookup Method: Linear_Endpoint
       *
       * Row Data    parameter uses the same data type and scaling as Input0
       * Column Data parameter uses the same data type and scaling as Input1
       * Table Data  parameter uses the same data type and scaling as Output0


       */
      Look2D_real_T_real_T_real_T( &(rtb_EngineTorqueData),
        Vehicle_Plant_P.EngineTorqueData_Table, rtb_radtorpm,
        Vehicle_Plant_P.EngineTorqueData_RowIdx, 8U, rtb_Switch,
        Vehicle_Plant_P.EngineTorqueData_ColIdx, 5U);
      Vehicle_Plant_B.Switch1 = rtb_EngineTorqueData;
    } else {
      Vehicle_Plant_B.Switch1 = Vehicle_Plant_P.Throttle2_Value;
    }

    /* Switch: '<S5>/Switch2' incorporates:
     *  Constant: '<S5>/Throttle3'
     *  Inport: '<Root>/Engine_On'
     *  Lookup2D: '<S5>/Fuel Consumption Data'
     */
    if (Vehicle_Plant_U.Engine_On >= Vehicle_Plant_P.Switch2_Threshold) {
      /* Lookup2D Block: '<S5>/Fuel Consumption Data'
       * About '<S5>/Fuel Consumption Data :'
       * Lookup2D Block: '<S5>/Fuel Consumption Data'
       * Input0  Data Type:  Floating Point real_T
       * Input1  Data Type:  Floating Point real_T
       * Output0 Data Type:  Floating Point real_T
       * Lookup Method: Linear_Endpoint
       *
       * Row Data    parameter uses the same data type and scaling as Input0
       * Column Data parameter uses the same data type and scaling as Input1
       * Table Data  parameter uses the same data type and scaling as Output0


       */
      Look2D_real_T_real_T_real_T( &(rtb_Fuel_Rate),
        Vehicle_Plant_P.FuelConsumptionData_Table, rtb_radtorpm,
        Vehicle_Plant_P.FuelConsumptionData_RowIdx, 8U, rtb_Switch,
        Vehicle_Plant_P.FuelConsumptionData_ColIdx, 5U);
      Vehicle_Plant_B.Switch2 = rtb_Fuel_Rate;
    } else {
      Vehicle_Plant_B.Switch2 = Vehicle_Plant_P.Throttle3_Value;
    }

    /* TransferFcn Block: '<S5>/Transfer Fcn' */
    rtb_TransferFcn1 = Vehicle_Plant_P.TransferFcn_C*
      Vehicle_Plant_X.TransferFcn_CSTATE;
    if (rtmIsMajorTimeStep(Vehicle_Plant_M)) {
    }

    /* Abs: '<S6>/Abs2' */
    Vehicle_Plant_B.Abs2_a = fabs(rtb_Product_n);
    if (rtmIsMajorTimeStep(Vehicle_Plant_M)) {
      /* Switch: '<S22>/SwitchControl' incorporates:
       *  Constant: '<S22>/Constant'
       *  Constant: '<S6>/Constant2'
       *  Inport: '<Root>/Gen_Enable'
       */
      if (Vehicle_Plant_P.Constant_Value_e >
          Vehicle_Plant_P.SwitchControl_Threshold_h) {
        Vehicle_Plant_B.SwitchControl_n = Vehicle_Plant_U.Gen_Enable;
      } else {
        Vehicle_Plant_B.SwitchControl_n = Vehicle_Plant_P.Constant2_Value_f;
      }
    }

    /* Saturate: '<S30>/Saturation 0 to 1' incorporates:
     *  Inport: '<Root>/Brake_request'
     */
    rtb_Product_g = rt_SATURATE(Vehicle_Plant_U.Brake_Request,
      Vehicle_Plant_P.Saturation0to1_LowerSat,
      Vehicle_Plant_P.Saturation0to1_UpperSat);

    /* RateLimiter: '<S30>/Brake Slew Rate (.25 s)' */
    if (Vehicle_Plant_DWork.LastMajorTime_n == (rtInf)) {
      Vehicle_Plant_B.BrakeSlewRate25s = rtb_Product_g;
    } else {
      rtb_Sum1_i = Vehicle_Plant_M->Timing.t[0] -
        Vehicle_Plant_DWork.LastMajorTime_n;
      rtb_Product_hc = rtb_Sum1_i * Vehicle_Plant_P.BrakeSlewRate25s_RisingLim;
      rtb_Sum2 = rtb_Product_g - Vehicle_Plant_DWork.PrevY_k;
      if (rtb_Sum2 > rtb_Product_hc) {
        Vehicle_Plant_B.BrakeSlewRate25s = Vehicle_Plant_DWork.PrevY_k +
          rtb_Product_hc;
      } else {
        rtb_Sum1_i *= Vehicle_Plant_P.BrakeSlewRate25s_FallingLim;
        if (rtb_Sum2 < rtb_Sum1_i) {
          Vehicle_Plant_B.BrakeSlewRate25s = Vehicle_Plant_DWork.PrevY_k +
            rtb_Sum1_i;
        } else {
          Vehicle_Plant_B.BrakeSlewRate25s = rtb_Product_g;
        }
      }
    }

    /* Gain: '<S30>/Brake Max Torque' */
    rtb_Product_g = Vehicle_Plant_P.BrakeMaxTorque_Gain *
      Vehicle_Plant_B.BrakeSlewRate25s;

    /* Gain: '<S30>/m//s to mph' incorporates:
     *  Abs: '<S30>/Abs'
     */
    rtb_mstomph = Vehicle_Plant_P.mstomph_Gain * fabs(Vehicle_Plant_B.Integrator);

    /* Lookup Block: '<S30>/Brake Torque Map'
     * About '<S30>/Brake Torque Map :'
     * Lookup Block: '<S30>/Brake Torque Map'
     * Input0  Data Type:  Floating Point real_T
     * Output0 Data Type:  Floating Point real_T
     * Lookup Method: Linear_Endpoint
     *
     * XData parameter uses the same data type and scaling as Input0
     * YData parameter uses the same data type and scaling as Output0


     */
    LookUp_real_T_real_T( &(rtb_BrakeTorqueMap),
                         Vehicle_Plant_P.BrakeTorqueMap_YData, rtb_mstomph,
                         Vehicle_Plant_P.BrakeTorqueMap_XData, 2U);

    /* Gain: '<S50>/Gain V' */
    rtb_GainV_l = Vehicle_Plant_P.GainV_Gain_p *
      Vehicle_Plant_B.KinematicBlock_o4[4];

    /* Lookup Block: '<S30>/SGN'
     * About '<S30>/SGN :'
     * Lookup Block: '<S30>/SGN'
     * Input0  Data Type:  Floating Point real_T
     * Output0 Data Type:  Floating Point real_T
     * Lookup Method: Linear_Endpoint
     *
     * XData parameter uses the same data type and scaling as Input0
     * YData parameter uses the same data type and scaling as Output0


     */
    LookUp_real_T_real_T( &(Vehicle_Plant_B.SGN), Vehicle_Plant_P.SGN_YData,
                         rtb_GainV_l, Vehicle_Plant_P.SGN_XData, 4U);

    /* RateLimiter: '<S30>/Rate Limiter 10, -10' */
    if (Vehicle_Plant_DWork.LastMajorTime_a == (rtInf)) {
      Vehicle_Plant_B.RateLimiter1010 = Vehicle_Plant_B.SGN;
    } else {
      rtb_Sum1_i = Vehicle_Plant_M->Timing.t[0] -
        Vehicle_Plant_DWork.LastMajorTime_a;
      rtb_Product_hc = rtb_Sum1_i * Vehicle_Plant_P.RateLimiter1010_RisingLim;
      rtb_Sum2 = Vehicle_Plant_B.SGN - Vehicle_Plant_DWork.PrevY_o;
      if (rtb_Sum2 > rtb_Product_hc) {
        Vehicle_Plant_B.RateLimiter1010 = Vehicle_Plant_DWork.PrevY_o +
          rtb_Product_hc;
      } else {
        rtb_Sum1_i *= Vehicle_Plant_P.RateLimiter1010_FallingLim;
        if (rtb_Sum2 < rtb_Sum1_i) {
          Vehicle_Plant_B.RateLimiter1010 = Vehicle_Plant_DWork.PrevY_o +
            rtb_Sum1_i;
        } else {
          Vehicle_Plant_B.RateLimiter1010 = Vehicle_Plant_B.SGN;
        }
      }
    }

    /* Product: '<S30>/Product' incorporates:
     *  Abs: '<S30>/Abs'
     *  Gain: '<S30>/m//s to mph'
     *  Lookup: '<S30>/Brake Torque Map'
     *  Product: '<S30>/Product1'
     */
    rtb_Product_n = rtb_BrakeTorqueMap * rtb_Product_g *
      Vehicle_Plant_B.RateLimiter1010;

    /* Saturate: '<S31>/Saturation 0 to 1' incorporates:
     *  Inport: '<Root>/Brake_request'
     */
    rtb_Product_g = rt_SATURATE(Vehicle_Plant_U.Brake_Request,
      Vehicle_Plant_P.Saturation0to1_LowerSat_d,
      Vehicle_Plant_P.Saturation0to1_UpperSat_c);

    /* RateLimiter: '<S31>/Brake Slew Rate (.25 s)' */
    if (Vehicle_Plant_DWork.LastMajorTime_o == (rtInf)) {
      Vehicle_Plant_B.BrakeSlewRate25s_c = rtb_Product_g;
    } else {
      rtb_Sum1_i = Vehicle_Plant_M->Timing.t[0] -
        Vehicle_Plant_DWork.LastMajorTime_o;
      rtb_Product_hc = rtb_Sum1_i * Vehicle_Plant_P.BrakeSlewRate25s_RisingLim_l;
      rtb_Sum2 = rtb_Product_g - Vehicle_Plant_DWork.PrevY_p;
      if (rtb_Sum2 > rtb_Product_hc) {
        Vehicle_Plant_B.BrakeSlewRate25s_c = Vehicle_Plant_DWork.PrevY_p +
          rtb_Product_hc;
      } else {
        rtb_Sum1_i *= Vehicle_Plant_P.BrakeSlewRate25s_FallingLim_b;
        if (rtb_Sum2 < rtb_Sum1_i) {
          Vehicle_Plant_B.BrakeSlewRate25s_c = Vehicle_Plant_DWork.PrevY_p +
            rtb_Sum1_i;
        } else {
          Vehicle_Plant_B.BrakeSlewRate25s_c = rtb_Product_g;
        }
      }
    }

    /* Gain: '<S31>/Brake Max Torque' */
    rtb_Sum2 = Vehicle_Plant_P.BrakeMaxTorque_Gain_n *
      Vehicle_Plant_B.BrakeSlewRate25s_c;

    /* Gain: '<S31>/m//s to mph' incorporates:
     *  Abs: '<S31>/Abs'
     */
    rtb_mstomph_l = Vehicle_Plant_P.mstomph_Gain_i * fabs
      (Vehicle_Plant_B.Integrator);

    /* Lookup Block: '<S31>/Brake Torque Map'
     * About '<S31>/Brake Torque Map :'
     * Lookup Block: '<S31>/Brake Torque Map'
     * Input0  Data Type:  Floating Point real_T
     * Output0 Data Type:  Floating Point real_T
     * Lookup Method: Linear_Endpoint
     *
     * XData parameter uses the same data type and scaling as Input0
     * YData parameter uses the same data type and scaling as Output0


     */
    LookUp_real_T_real_T( &(rtb_BrakeTorqueMap_j),
                         Vehicle_Plant_P.BrakeTorqueMap_YData_o, rtb_mstomph_l,
                         Vehicle_Plant_P.BrakeTorqueMap_XData_j, 2U);

    /* Gain: '<S54>/Gain V' */
    rtb_GainV_e = Vehicle_Plant_P.GainV_Gain_h0 *
      Vehicle_Plant_B.KinematicBlock_o4[0];

    /* Lookup Block: '<S31>/SGN'
     * About '<S31>/SGN :'
     * Lookup Block: '<S31>/SGN'
     * Input0  Data Type:  Floating Point real_T
     * Output0 Data Type:  Floating Point real_T
     * Lookup Method: Linear_Endpoint
     *
     * XData parameter uses the same data type and scaling as Input0
     * YData parameter uses the same data type and scaling as Output0


     */
    LookUp_real_T_real_T( &(Vehicle_Plant_B.SGN_g), Vehicle_Plant_P.SGN_YData_i,
                         rtb_GainV_e, Vehicle_Plant_P.SGN_XData_h, 4U);

    /* RateLimiter: '<S31>/Rate Limiter 10, -10' */
    if (Vehicle_Plant_DWork.LastMajorTime_d == (rtInf)) {
      Vehicle_Plant_B.RateLimiter1010_o = Vehicle_Plant_B.SGN_g;
    } else {
      rtb_Sum1_i = Vehicle_Plant_M->Timing.t[0] -
        Vehicle_Plant_DWork.LastMajorTime_d;
      rtb_Product_hc = rtb_Sum1_i * Vehicle_Plant_P.RateLimiter1010_RisingLim_j;
      rtb_Product_g = Vehicle_Plant_B.SGN_g - Vehicle_Plant_DWork.PrevY_i;
      if (rtb_Product_g > rtb_Product_hc) {
        Vehicle_Plant_B.RateLimiter1010_o = Vehicle_Plant_DWork.PrevY_i +
          rtb_Product_hc;
      } else {
        rtb_Sum1_i *= Vehicle_Plant_P.RateLimiter1010_FallingLim_a;
        if (rtb_Product_g < rtb_Sum1_i) {
          Vehicle_Plant_B.RateLimiter1010_o = Vehicle_Plant_DWork.PrevY_i +
            rtb_Sum1_i;
        } else {
          Vehicle_Plant_B.RateLimiter1010_o = Vehicle_Plant_B.SGN_g;
        }
      }
    }

    /* Gain: '<S32>/Frontal area' incorporates:
     *  Gain: '<S32>/Drag coefficient'
     *  Gain: '<S32>/Gain3'
     *  Gain: '<S32>/rho'
     *  Math: '<S59>/Math Function'
     *  Product: '<S59>/Product'
     *  Signum: '<S59>/Sign'
     */
    rtb_Frontalarea = Vehicle_Plant_B.Integrator * Vehicle_Plant_B.Integrator *
      rt_SIGNd_snf(Vehicle_Plant_B.Integrator) * Vehicle_Plant_P.Gain3_Gain_a *
      Vehicle_Plant_P.rho_Gain * Vehicle_Plant_P.Dragcoefficient_Gain *
      Vehicle_Plant_P.Frontalarea_Gain;

    /* SignalConversion: '<S42>/TmpHiddenBufferAtDynamic BlockInport1' incorporates:
     *  Abs: '<S31>/Abs'
     *  Gain: '<S31>/m//s to mph'
     *  Lookup: '<S31>/Brake Torque Map'
     *  Product: '<S31>/Product'
     *  Product: '<S31>/Product1'
     */
    Vehicle_Plant_B.TmpHiddenBufferAtDynamicBlockIn[0] = rtb_BrakeTorqueMap_j *
      rtb_Sum2 * Vehicle_Plant_B.RateLimiter1010_o;
    Vehicle_Plant_B.TmpHiddenBufferAtDynamicBlockIn[1] = rtb_TransferFcn1;
    Vehicle_Plant_B.TmpHiddenBufferAtDynamicBlockIn[2] = Vehicle_Plant_B.MinMax;
    Vehicle_Plant_B.TmpHiddenBufferAtDynamicBlockIn[3] =
      Vehicle_Plant_B.MinMax_c;
    Vehicle_Plant_B.TmpHiddenBufferAtDynamicBlockIn[4] = rtb_Product_n;

    /* S-Function Block: <S42>/Dynamic Block */
    {
      DriveSimulationData *_simdata = NULL;
      _simdata = (DriveSimulationData *) Vehicle_Plant_DWork.DynamicBlock_PWORK;
      _simdata->driveLine->time = Vehicle_Plant_M->Timing.t[0];
      _simdata->driveLine->ismajortimestep = rtmIsMajorTimeStep(Vehicle_Plant_M);
      if (driveDynamicSfcnOutputs(_simdata)) {
        memcpy(_simdata->driveLine->engineError, driveGetErrorMsg(), sizeof
               (DriveErrorRecord));
        _simdata->driveLine->engineError->errorFlag = true;
        rtmSetErrorStatus(Vehicle_Plant_M, _simdata->driveLine->
                          engineError->errorMsg);
        return;
      }
    }

    if (rtmIsMajorTimeStep(Vehicle_Plant_M)) {
      /* Gain: '<S32>/Incline gravity' incorporates:
       *  Constant: '<S7>/Constant'
       *  Trigonometry: '<S32>/Trigonometric Function'
       */
      Vehicle_Plant_B.Inclinegravity = Vehicle_Plant_P.Inclinegravity_Gain * sin
        (Vehicle_Plant_P.Constant_Value_j);
    }

    /* Sum: '<S32>/Sum' incorporates:
     *  Constant: '<S7>/Constant1'
     *  Gain: '<S34>/Gain2'
     *  Gain: '<S35>/Gain2'
     *  Gain: '<S61>/Gain'
     *  Gain: '<S65>/Gain'
     *  Sum: '<S32>/Sum1'
     *  Sum: '<S7>/Sum'
     */
    Vehicle_Plant_B.Sum_b = (((Vehicle_Plant_P.Gain_Gain_j *
      Vehicle_Plant_B.DynamicBlock_o2[5] * Vehicle_Plant_P.Gain2_Gain +
      Vehicle_Plant_P.Gain_Gain_g * Vehicle_Plant_B.DynamicBlock_o2[0] *
      Vehicle_Plant_P.Gain2_Gain_c) + Vehicle_Plant_P.Constant1_Value_m) -
      rtb_Frontalarea) - Vehicle_Plant_B.Inclinegravity;

    /* Gain: '<S32>/Gain1' */
    Vehicle_Plant_B.Gain1_e = Vehicle_Plant_P.Gain1_Gain_c *
      Vehicle_Plant_B.Sum_b;

    /* TransferFcn Block: '<S32>/Transfer Fcn1' */
    rtb_TransferFcn1 = Vehicle_Plant_P.TransferFcn1_C[0]*
      Vehicle_Plant_X.TransferFcn1_CSTATE[0]
      + Vehicle_Plant_P.TransferFcn1_C[1]*Vehicle_Plant_X.TransferFcn1_CSTATE[1];

    /* S-Function Block: <S42>/Event Block */
    {
      DriveSimulationData *_simdata = NULL;
      _simdata = (DriveSimulationData *) Vehicle_Plant_DWork.EventBlock_PWORK;
      _simdata->driveLine->time = Vehicle_Plant_M->Timing.t[0];
      _simdata->driveLine->ismajortimestep = rtmIsMajorTimeStep(Vehicle_Plant_M);
      if (driveEventSfcnOutputs(_simdata)) {
        memcpy(_simdata->driveLine->engineError, driveGetErrorMsg(), sizeof
               (DriveErrorRecord));
        _simdata->driveLine->engineError->errorFlag = true;
        rtmSetErrorStatus(Vehicle_Plant_M, _simdata->driveLine->
                          engineError->errorMsg);
        return;
      }

      _simdata->driveLine->needToReadRtp = false;
    }

    /* S-Function Block: <S44>/Event Feedback */
    Vehicle_Plant_B.EventFeedback = 0;
  }

  /* tid is required for a uniform function interface.
   * Argument tid is not used in the function. */
  UNUSED_PARAMETER(tid);
}

/* Model update function */
void Vehicle_Plant_update(int_T tid)
{
  if (rtmIsMajorTimeStep(Vehicle_Plant_M)) {
    /* Update for Memory: '<S6>/Memory' */
    Vehicle_Plant_DWork.Memory_PreviousInput = Vehicle_Plant_B.Abs2_a;

    /* Update for Memory: '<S6>/Memory1' */
    Vehicle_Plant_DWork.Memory1_PreviousInput = Vehicle_Plant_B.SwitchControl_n;

    /* Update for Memory: '<S3>/Memory' */
    Vehicle_Plant_DWork.Memory_PreviousInput_n = Vehicle_Plant_B.Sum;

    /* Update for Memory: '<S3>/Memory1' */
    Vehicle_Plant_DWork.Memory1_PreviousInput_k = Vehicle_Plant_B.SwitchControl;

    /* Update for Memory: '<S4>/Memory1' */
    Vehicle_Plant_DWork.Memory1_PreviousInput_j =
      Vehicle_Plant_B.SwitchControl_j;

    /* Update for Memory: '<S4>/Memory' */
    Vehicle_Plant_DWork.Memory_PreviousInput_m = Vehicle_Plant_B.Abs2;

    /* Update for DiscreteIntegrator: '<S1>/Discrete-Time Integrator' incorporates:
     *  Constant: '<S1>/Constant'
     */
    Vehicle_Plant_DWork.DiscreteTimeIntegrator_DSTATE =
      Vehicle_Plant_P.DiscreteTimeIntegrator_gainval *
      Vehicle_Plant_P.Constant_Value_k +
      Vehicle_Plant_DWork.DiscreteTimeIntegrator_DSTATE;
  }

  /* Update for RateLimiter: '<S3>/Rate Limiter' */
  Vehicle_Plant_DWork.PrevY = Vehicle_Plant_B.RateLimiter;
  Vehicle_Plant_DWork.LastMajorTime = Vehicle_Plant_M->Timing.t[0];

  /* Update for RateLimiter: '<S30>/Brake Slew Rate (.25 s)' */
  Vehicle_Plant_DWork.PrevY_k = Vehicle_Plant_B.BrakeSlewRate25s;
  Vehicle_Plant_DWork.LastMajorTime_n = Vehicle_Plant_M->Timing.t[0];

  /* Update for RateLimiter: '<S30>/Rate Limiter 10, -10' */
  Vehicle_Plant_DWork.PrevY_o = Vehicle_Plant_B.RateLimiter1010;
  Vehicle_Plant_DWork.LastMajorTime_a = Vehicle_Plant_M->Timing.t[0];

  /* Update for RateLimiter: '<S31>/Brake Slew Rate (.25 s)' */
  Vehicle_Plant_DWork.PrevY_p = Vehicle_Plant_B.BrakeSlewRate25s_c;
  Vehicle_Plant_DWork.LastMajorTime_o = Vehicle_Plant_M->Timing.t[0];

  /* Update for RateLimiter: '<S31>/Rate Limiter 10, -10' */
  Vehicle_Plant_DWork.PrevY_i = Vehicle_Plant_B.RateLimiter1010_o;
  Vehicle_Plant_DWork.LastMajorTime_d = Vehicle_Plant_M->Timing.t[0];
  if (rtmIsMajorTimeStep(Vehicle_Plant_M)) {
    rt_ertODEUpdateContinuousStates(&Vehicle_Plant_M->solverInfo);
  }

  /* Update absolute time for base rate */
  /* The "clockTick0" counts the number of times the code of this task has
   * been executed. The absolute time is the multiplication of "clockTick0"
   * and "Timing.stepSize0". Size of "clockTick0" ensures timer will not
   * overflow during the application lifespan selected.
   * Timer of this task consists of two 32 bit unsigned integers.
   * The two integers represent the low bits Timing.clockTick0 and the high bits
   * Timing.clockTickH0. When the low bit overflows to 0, the high bits increment.
   */
  if (!(++Vehicle_Plant_M->Timing.clockTick0))
    ++Vehicle_Plant_M->Timing.clockTickH0;
  Vehicle_Plant_M->Timing.t[0] = Vehicle_Plant_M->Timing.clockTick0 *
    Vehicle_Plant_M->Timing.stepSize0 + Vehicle_Plant_M->Timing.clockTickH0 *
    Vehicle_Plant_M->Timing.stepSize0 * 4294967296.0;
  if (rtmIsMajorTimeStep(Vehicle_Plant_M)) {
    /* Update absolute timer for sample time: [0.01s, 0.0s] */
    /* The "clockTick1" counts the number of times the code of this task has
     * been executed. The absolute time is the multiplication of "clockTick1"
     * and "Timing.stepSize1". Size of "clockTick1" ensures timer will not
     * overflow during the application lifespan selected.
     * Timer of this task consists of two 32 bit unsigned integers.
     * The two integers represent the low bits Timing.clockTick1 and the high bits
     * Timing.clockTickH1. When the low bit overflows to 0, the high bits increment.
     */
    if (!(++Vehicle_Plant_M->Timing.clockTick1))
      ++Vehicle_Plant_M->Timing.clockTickH1;
    Vehicle_Plant_M->Timing.t[1] = Vehicle_Plant_M->Timing.clockTick1 *
      Vehicle_Plant_M->Timing.stepSize1 + Vehicle_Plant_M->Timing.clockTickH1 *
      Vehicle_Plant_M->Timing.stepSize1 * 4294967296.0;
  }

  /* tid is required for a uniform function interface.
   * Argument tid is not used in the function. */
  UNUSED_PARAMETER(tid);
}

/* Derivatives for root system: '<Root>' */
void Vehicle_Plant_derivatives(void)
{
  /* Derivatives for Integrator: '<S64>/integrator' */
  ((StateDerivatives_Vehicle_Plant *) Vehicle_Plant_M->ModelData.derivs)
    ->integrator_CSTATE = Vehicle_Plant_B.Gain1;

  /* Derivatives for Integrator: '<S32>/Integrator' */
  ((StateDerivatives_Vehicle_Plant *) Vehicle_Plant_M->ModelData.derivs)
    ->Integrator_CSTATE = Vehicle_Plant_B.Gain1_e;

  /* Derivatives for Integrator: '<S60>/integrator' */
  ((StateDerivatives_Vehicle_Plant *) Vehicle_Plant_M->ModelData.derivs)
    ->integrator_CSTATE_k = Vehicle_Plant_B.Gain1_b;

  /* S-Function Block: <S42>/Parameter Block */
  {
  }

  /* S-Function Block: <S42>/Kinematic Block */
  {
    DriveSimulationData *_simdata = NULL;
    _simdata = (DriveSimulationData *) Vehicle_Plant_DWork.KinematicBlock_PWORK;
    _simdata->driveLine->time = Vehicle_Plant_M->Timing.t[0];
    _simdata->driveLine->ismajortimestep = rtmIsMajorTimeStep(Vehicle_Plant_M);
    _simdata->dx = &((StateDerivatives_Vehicle_Plant *)
                     Vehicle_Plant_M->ModelData.derivs)->KinematicBlock_CSTATE[0];
    if (driveKinematicSfcnDerivatives(_simdata)) {
      memcpy(_simdata->driveLine->engineError, driveGetErrorMsg(), sizeof
             (DriveErrorRecord));
      _simdata->driveLine->engineError->errorFlag = true;
      rtmSetErrorStatus(Vehicle_Plant_M, _simdata->driveLine->
                        engineError->errorMsg);
      return;
    }
  }

  /* Derivatives for Integrator: '<S3>/Integrator' */
  ((StateDerivatives_Vehicle_Plant *) Vehicle_Plant_M->ModelData.derivs)
    ->Integrator_CSTATE_h = Vehicle_Plant_B.Memory_f;

  /* Derivatives for Integrator: '<S5>/Integrator' */
  ((StateDerivatives_Vehicle_Plant *) Vehicle_Plant_M->ModelData.derivs)
    ->Integrator_CSTATE_e = Vehicle_Plant_B.Switch2;

  /* TransferFcn Block: '<S5>/Transfer Fcn' */
  {
    ((StateDerivatives_Vehicle_Plant *) Vehicle_Plant_M->ModelData.derivs)
      ->TransferFcn_CSTATE = Vehicle_Plant_B.Switch1;
    ((StateDerivatives_Vehicle_Plant *) Vehicle_Plant_M->ModelData.derivs)
      ->TransferFcn_CSTATE += (Vehicle_Plant_P.TransferFcn_A)*
      Vehicle_Plant_X.TransferFcn_CSTATE;
  }

  /* Derivatives for Integrator: '<S7>/Integrator' */
  ((StateDerivatives_Vehicle_Plant *) Vehicle_Plant_M->ModelData.derivs)
    ->Integrator_CSTATE_a = Vehicle_Plant_B.Integrator;

  /* S-Function Block: <S42>/Dynamic Block */
  {
  }

  /* TransferFcn Block: '<S32>/Transfer Fcn1' */
  {
    ((StateDerivatives_Vehicle_Plant *) Vehicle_Plant_M->ModelData.derivs)
      ->TransferFcn1_CSTATE[0] = Vehicle_Plant_B.Sum_b;
    ((StateDerivatives_Vehicle_Plant *) Vehicle_Plant_M->ModelData.derivs)
      ->TransferFcn1_CSTATE[0] += (Vehicle_Plant_P.TransferFcn1_A[0])*
      Vehicle_Plant_X.TransferFcn1_CSTATE[0]
      + (Vehicle_Plant_P.TransferFcn1_A[1])*Vehicle_Plant_X.TransferFcn1_CSTATE
      [1];
    ((StateDerivatives_Vehicle_Plant *) Vehicle_Plant_M->ModelData.derivs)
      ->TransferFcn1_CSTATE[1]= Vehicle_Plant_X.TransferFcn1_CSTATE[0];
  }

  /* S-Function Block: <S42>/Event Block */
  {
  }
}

/* Model initialize function */
void Vehicle_Plant_initialize(boolean_T firstTime)
{
  (void)firstTime;

  /* Registration code */

  /* initialize non-finites */
  rt_InitInfAndNaN(sizeof(real_T));

  /* non-finite (run-time) assignments */
  Vehicle_Plant_P.InitialCondition_Value = rtNaN;
  Vehicle_Plant_P.InitialCondition_Value_m = rtNaN;
  Vehicle_Plant_P.InitialCondition_Value_b = rtNaN;
  Vehicle_Plant_P.InitialCondition_Value_e = rtNaN;
  Vehicle_Plant_P.InitialCondition_Value_a = rtNaN;
  Vehicle_Plant_P.RateLimiter_FallingLim = rtMinusInf;

  /* initialize real-time model */
  (void) memset((void *)Vehicle_Plant_M,0,
                sizeof(RT_MODEL_Vehicle_Plant));

  {
    /* Setup solver object */
    rtsiSetSimTimeStepPtr(&Vehicle_Plant_M->solverInfo,
                          &Vehicle_Plant_M->Timing.simTimeStep);
    rtsiSetTPtr(&Vehicle_Plant_M->solverInfo, &rtmGetTPtr(Vehicle_Plant_M));
    rtsiSetStepSizePtr(&Vehicle_Plant_M->solverInfo,
                       &Vehicle_Plant_M->Timing.stepSize0);
    rtsiSetdXPtr(&Vehicle_Plant_M->solverInfo,
                 &Vehicle_Plant_M->ModelData.derivs);
    rtsiSetContStatesPtr(&Vehicle_Plant_M->solverInfo,
                         &Vehicle_Plant_M->ModelData.contStates);
    rtsiSetNumContStatesPtr(&Vehicle_Plant_M->solverInfo,
      &Vehicle_Plant_M->Sizes.numContStates);
    rtsiSetErrorStatusPtr(&Vehicle_Plant_M->solverInfo, (&rtmGetErrorStatus
      (Vehicle_Plant_M)));
    rtsiSetRTModelPtr(&Vehicle_Plant_M->solverInfo, Vehicle_Plant_M);
  }

  rtsiSetSimTimeStep(&Vehicle_Plant_M->solverInfo, MAJOR_TIME_STEP);
  Vehicle_Plant_M->ModelData.intgData.y = Vehicle_Plant_M->ModelData.odeY;
  Vehicle_Plant_M->ModelData.intgData.f[0] = Vehicle_Plant_M->ModelData.odeF[0];
  Vehicle_Plant_M->ModelData.intgData.f[1] = Vehicle_Plant_M->ModelData.odeF[1];
  Vehicle_Plant_M->ModelData.intgData.f[2] = Vehicle_Plant_M->ModelData.odeF[2];
  Vehicle_Plant_M->ModelData.intgData.f[3] = Vehicle_Plant_M->ModelData.odeF[3];
  Vehicle_Plant_M->ModelData.contStates = ((real_T *) &Vehicle_Plant_X);
  rtsiSetSolverData(&Vehicle_Plant_M->solverInfo, (void *)
                    &Vehicle_Plant_M->ModelData.intgData);
  rtsiSetSolverName(&Vehicle_Plant_M->solverInfo,"ode4");

  /* Initialize timing info */
  {
    int_T *mdlTsMap = Vehicle_Plant_M->Timing.sampleTimeTaskIDArray;
    mdlTsMap[0] = 0;
    mdlTsMap[1] = 1;
    Vehicle_Plant_M->Timing.sampleTimeTaskIDPtr = (&mdlTsMap[0]);
    Vehicle_Plant_M->Timing.sampleTimes =
      (&Vehicle_Plant_M->Timing.sampleTimesArray[0]);
    Vehicle_Plant_M->Timing.offsetTimes =
      (&Vehicle_Plant_M->Timing.offsetTimesArray[0]);

    /* task periods */
    Vehicle_Plant_M->Timing.sampleTimes[0] = (0.0);
    Vehicle_Plant_M->Timing.sampleTimes[1] = (0.01);

    /* task offsets */
    Vehicle_Plant_M->Timing.offsetTimes[0] = (0.0);
    Vehicle_Plant_M->Timing.offsetTimes[1] = (0.0);
  }

  rtmSetTPtr(Vehicle_Plant_M, &Vehicle_Plant_M->Timing.tArray[0]);

  {
    int_T *mdlSampleHits = Vehicle_Plant_M->Timing.sampleHitArray;
    mdlSampleHits[0] = 1;
    mdlSampleHits[1] = 1;
    Vehicle_Plant_M->Timing.sampleHits = (&mdlSampleHits[0]);
  }

  rtmSetTFinal(Vehicle_Plant_M, -1);
  Vehicle_Plant_M->Timing.stepSize0 = 0.01;
  Vehicle_Plant_M->Timing.stepSize1 = 0.01;
  rtmSetFirstInitCond(Vehicle_Plant_M, 1);

  /* Setup for data logging */
  {
    static RTWLogInfo rt_DataLoggingInfo;
    Vehicle_Plant_M->rtwLogInfo = &rt_DataLoggingInfo;
    rtliSetLogXSignalInfo(Vehicle_Plant_M->rtwLogInfo, (NULL));
    rtliSetLogXSignalPtrs(Vehicle_Plant_M->rtwLogInfo, (NULL));
    rtliSetLogT(Vehicle_Plant_M->rtwLogInfo, "tout");
    rtliSetLogX(Vehicle_Plant_M->rtwLogInfo, "");
    rtliSetLogXFinal(Vehicle_Plant_M->rtwLogInfo, "");
    rtliSetSigLog(Vehicle_Plant_M->rtwLogInfo, "");
    rtliSetLogVarNameModifier(Vehicle_Plant_M->rtwLogInfo, "rt_");
    rtliSetLogFormat(Vehicle_Plant_M->rtwLogInfo, 0);
    rtliSetLogMaxRows(Vehicle_Plant_M->rtwLogInfo, 1000);
    rtliSetLogDecimation(Vehicle_Plant_M->rtwLogInfo, 1);

    /*
     * Set pointers to the data and signal info for each output
     */
    {
      static void * rt_LoggedOutputSignalPtrs[] = {
        &Vehicle_Plant_Y.Measured_Engine_rpm,
        &Vehicle_Plant_Y.Battery_SOC,
        &Vehicle_Plant_Y.Generator_Current_A,
        &Vehicle_Plant_Y.Battery_Pack_State,
        &Vehicle_Plant_Y.Motor_State,
        &Vehicle_Plant_Y.Gen_State,
        &Vehicle_Plant_Y.Motor_Current_A,
        &Vehicle_Plant_Y.Motor_rpm
      };

      rtliSetLogYSignalPtrs(Vehicle_Plant_M->rtwLogInfo, ((LogSignalPtrsType)
        rt_LoggedOutputSignalPtrs));
    }

    {
      static int_T rt_LoggedOutputWidths[] = {
        1,
        1,
        1,
        1,
        1,
        1,
        1,
        1
      };

      static int_T rt_LoggedOutputNumDimensions[] = {
        1,
        1,
        1,
        1,
        1,
        1,
        1,
        1
      };

      static int_T rt_LoggedOutputDimensions[] = {
        1,
        1,
        1,
        1,
        1,
        1,
        1,
        1
      };

      static boolean_T rt_LoggedOutputIsVarDims[] = {
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0
      };

      static int_T* rt_LoggedCurrentSignalDimensions[] = {
        (NULL),
        (NULL),
        (NULL),
        (NULL),
        (NULL),
        (NULL),
        (NULL),
        (NULL)
      };

      static BuiltInDTypeId rt_LoggedOutputDataTypeIds[] = {
        SS_DOUBLE,
        SS_DOUBLE,
        SS_DOUBLE,
        SS_DOUBLE,
        SS_DOUBLE,
        SS_DOUBLE,
        SS_DOUBLE,
        SS_DOUBLE
      };

      static int_T rt_LoggedOutputComplexSignals[] = {
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0
      };

      static const char_T *rt_LoggedOutputLabels[] = {
        "<Measured_Engine_rpm>",
        "<Battery_SOC>",
        "<Generator_Current_A>",
        "<Battery_Pack_State>",
        "<Motor_State>",
        "<Gen_State>",
        "<Motor_Current_A>",
        "<Motor_rpm>" };

      static const char_T *rt_LoggedOutputBlockNames[] = {
        "Vehicle_Plant/Measured_Engine_rpm",
        "Vehicle_Plant/Battery_SOC",
        "Vehicle_Plant/Generator_Current_A",
        "Vehicle_Plant/Battery_Pack_State",
        "Vehicle_Plant/Motor_State",
        "Vehicle_Plant/Gen_State",
        "Vehicle_Plant/Motor_Current_A",
        "Vehicle_Plant/Motor_rpm" };

      static RTWLogDataTypeConvert rt_RTWLogDataTypeConvert[] = {
        { 0, SS_DOUBLE, SS_DOUBLE, 0, 0, 0, 1.0, 0, 0.0 },

        { 0, SS_DOUBLE, SS_DOUBLE, 0, 0, 0, 1.0, 0, 0.0 },

        { 0, SS_DOUBLE, SS_DOUBLE, 0, 0, 0, 1.0, 0, 0.0 },

        { 0, SS_DOUBLE, SS_DOUBLE, 0, 0, 0, 1.0, 0, 0.0 },

        { 0, SS_DOUBLE, SS_DOUBLE, 0, 0, 0, 1.0, 0, 0.0 },

        { 0, SS_DOUBLE, SS_DOUBLE, 0, 0, 0, 1.0, 0, 0.0 },

        { 0, SS_DOUBLE, SS_DOUBLE, 0, 0, 0, 1.0, 0, 0.0 },

        { 0, SS_DOUBLE, SS_DOUBLE, 0, 0, 0, 1.0, 0, 0.0 }
      };

      static RTWLogSignalInfo rt_LoggedOutputSignalInfo[] = {
        {
          8,
          rt_LoggedOutputWidths,
          rt_LoggedOutputNumDimensions,
          rt_LoggedOutputDimensions,
          rt_LoggedOutputIsVarDims,
          rt_LoggedCurrentSignalDimensions,
          rt_LoggedOutputDataTypeIds,
          rt_LoggedOutputComplexSignals,
          (NULL),

          { rt_LoggedOutputLabels },
          (NULL),
          (NULL),
          (NULL),

          { rt_LoggedOutputBlockNames },

          { (NULL) },
          (NULL),
          rt_RTWLogDataTypeConvert
        }
      };

      rtliSetLogYSignalInfo(Vehicle_Plant_M->rtwLogInfo,
                            rt_LoggedOutputSignalInfo);

      /* set currSigDims field */
      rt_LoggedCurrentSignalDimensions[0] = &rt_LoggedOutputWidths[0];
      rt_LoggedCurrentSignalDimensions[1] = &rt_LoggedOutputWidths[1];
      rt_LoggedCurrentSignalDimensions[2] = &rt_LoggedOutputWidths[2];
      rt_LoggedCurrentSignalDimensions[3] = &rt_LoggedOutputWidths[3];
      rt_LoggedCurrentSignalDimensions[4] = &rt_LoggedOutputWidths[4];
      rt_LoggedCurrentSignalDimensions[5] = &rt_LoggedOutputWidths[5];
      rt_LoggedCurrentSignalDimensions[6] = &rt_LoggedOutputWidths[6];
      rt_LoggedCurrentSignalDimensions[7] = &rt_LoggedOutputWidths[7];
    }

    rtliSetLogY(Vehicle_Plant_M->rtwLogInfo, "yout");
  }

  Vehicle_Plant_M->solverInfoPtr = (&Vehicle_Plant_M->solverInfo);
  Vehicle_Plant_M->Timing.stepSize = (0.01);
  rtsiSetFixedStepSize(&Vehicle_Plant_M->solverInfo, 0.01);
  rtsiSetSolverMode(&Vehicle_Plant_M->solverInfo, SOLVER_MODE_SINGLETASKING);

  /* block I/O */
  Vehicle_Plant_M->ModelData.blockIO = ((void *) &Vehicle_Plant_B);

  {
    int_T i;
    for (i = 0; i < 6; i++) {
      Vehicle_Plant_B.TmpHiddenBufferAtKinematicBlock[i] = 0.0;
    }

    for (i = 0; i < 16; i++) {
      Vehicle_Plant_B.TmpHiddenBufferAtParameterBlock[i] = 0.0;
    }

    for (i = 0; i < 6; i++) {
      Vehicle_Plant_B.KinematicBlock_o1[i] = 0.0;
    }

    for (i = 0; i < 5; i++) {
      Vehicle_Plant_B.KinematicBlock_o4[i] = 0.0;
    }

    for (i = 0; i < 5; i++) {
      Vehicle_Plant_B.TmpHiddenBufferAtDynamicBlockIn[i] = 0.0;
    }

    for (i = 0; i < 7; i++) {
      Vehicle_Plant_B.DynamicBlock_o2[i] = 0.0;
    }

    Vehicle_Plant_B.Integrator = 0.0;
    Vehicle_Plant_B.Gain1 = 0.0;
    Vehicle_Plant_B.Gain1_b = 0.0;
    Vehicle_Plant_B.ParameterBlock = 0.0;
    Vehicle_Plant_B.KinematicBlock_o2[0] = 0.0;
    Vehicle_Plant_B.KinematicBlock_o2[1] = 0.0;
    Vehicle_Plant_B.KinematicBlock_o2[2] = 0.0;
    Vehicle_Plant_B.KinematicBlock_o3 = 0.0;
    Vehicle_Plant_B.Memory = 0.0;
    Vehicle_Plant_B.Memory1 = 0.0;
    Vehicle_Plant_B.Memory_f = 0.0;
    Vehicle_Plant_B.Memory1_g = 0.0;
    Vehicle_Plant_B.MinMax = 0.0;
    Vehicle_Plant_B.Memory1_j = 0.0;
    Vehicle_Plant_B.Memory_k = 0.0;
    Vehicle_Plant_B.MinMax_c = 0.0;
    Vehicle_Plant_B.Battery_Current = 0.0;
    Vehicle_Plant_B.Battery_SOC = 0.0;
    Vehicle_Plant_B.Battery_Voltage = 0.0;
    Vehicle_Plant_B.Engine_rpm = 0.0;
    Vehicle_Plant_B.Generator_Current = 0.0;
    Vehicle_Plant_B.Motor_Current = 0.0;
    Vehicle_Plant_B.Vehicle_Speed_mph = 0.0;
    Vehicle_Plant_B.Time = 0.0;
    Vehicle_Plant_B.RateLimiter = 0.0;
    Vehicle_Plant_B.SwitchControl = 0.0;
    Vehicle_Plant_B.Sum = 0.0;
    Vehicle_Plant_B.Abs2 = 0.0;
    Vehicle_Plant_B.SwitchControl_j = 0.0;
    Vehicle_Plant_B.Switch1 = 0.0;
    Vehicle_Plant_B.Switch2 = 0.0;
    Vehicle_Plant_B.Abs2_a = 0.0;
    Vehicle_Plant_B.SwitchControl_n = 0.0;
    Vehicle_Plant_B.BrakeSlewRate25s = 0.0;
    Vehicle_Plant_B.SGN = 0.0;
    Vehicle_Plant_B.RateLimiter1010 = 0.0;
    Vehicle_Plant_B.BrakeSlewRate25s_c = 0.0;
    Vehicle_Plant_B.SGN_g = 0.0;
    Vehicle_Plant_B.RateLimiter1010_o = 0.0;
    Vehicle_Plant_B.DynamicBlock_o1 = 0.0;
    Vehicle_Plant_B.Inclinegravity = 0.0;
    Vehicle_Plant_B.Sum_b = 0.0;
    Vehicle_Plant_B.Gain1_e = 0.0;
    Vehicle_Plant_B.EventBlock = 0.0;
    Vehicle_Plant_B.EventFeedback = 0.0;
  }

  /* parameters */
  Vehicle_Plant_M->ModelData.defaultParam = ((real_T *) &Vehicle_Plant_P);

  /* states (continuous) */
  {
    real_T *x = (real_T *) &Vehicle_Plant_X;
    Vehicle_Plant_M->ModelData.contStates = (x);
    (void) memset((void *)x,0,
                  sizeof(ContinuousStates_Vehicle_Plant));
  }

  /* states (dwork) */
  Vehicle_Plant_M->Work.dwork = ((void *) &Vehicle_Plant_DWork);
  (void) memset((void *)&Vehicle_Plant_DWork, 0,
                sizeof(D_Work_Vehicle_Plant));
  Vehicle_Plant_DWork.DiscreteTimeIntegrator_DSTATE = 0.0;
  Vehicle_Plant_DWork.Memory_PreviousInput = 0.0;
  Vehicle_Plant_DWork.Memory1_PreviousInput = 0.0;
  Vehicle_Plant_DWork.Memory_PreviousInput_n = 0.0;
  Vehicle_Plant_DWork.Memory1_PreviousInput_k = 0.0;
  Vehicle_Plant_DWork.Memory1_PreviousInput_j = 0.0;
  Vehicle_Plant_DWork.Memory_PreviousInput_m = 0.0;
  Vehicle_Plant_DWork.PrevY = 0.0;
  Vehicle_Plant_DWork.LastMajorTime = 0.0;
  Vehicle_Plant_DWork.PrevY_k = 0.0;
  Vehicle_Plant_DWork.LastMajorTime_n = 0.0;
  Vehicle_Plant_DWork.PrevY_o = 0.0;
  Vehicle_Plant_DWork.LastMajorTime_a = 0.0;
  Vehicle_Plant_DWork.PrevY_p = 0.0;
  Vehicle_Plant_DWork.LastMajorTime_o = 0.0;
  Vehicle_Plant_DWork.PrevY_i = 0.0;
  Vehicle_Plant_DWork.LastMajorTime_d = 0.0;

  /* external inputs */
  Vehicle_Plant_M->ModelData.inputs = (((void*) &Vehicle_Plant_U));
  Vehicle_Plant_U.Generator_Torque = 0.0;
  Vehicle_Plant_U.Engine_On = 0.0;
  Vehicle_Plant_U.Engine_Throttle = 0.0;
  Vehicle_Plant_U.Motor_Torque_Request = 0.0;
  Vehicle_Plant_U.Brake_Request = 0.0;
  Vehicle_Plant_U.Battery_Connect_Command = 0.0;
  Vehicle_Plant_U.Gen_Enable = 0.0;
  Vehicle_Plant_U.Motor_Enable = 0.0;

  /* external outputs */
  Vehicle_Plant_M->ModelData.outputs = (&Vehicle_Plant_Y);
  Vehicle_Plant_Y.Measured_Engine_rpm = 0.0;
  Vehicle_Plant_Y.Battery_SOC = 0.0;
  Vehicle_Plant_Y.Generator_Current_A = 0.0;
  Vehicle_Plant_Y.Battery_Pack_State = 0.0;
  Vehicle_Plant_Y.Motor_State = 0.0;
  Vehicle_Plant_Y.Gen_State = 0.0;
  Vehicle_Plant_Y.Motor_Current_A = 0.0;
  Vehicle_Plant_Y.Motor_rpm = 0.0;
}

/* Model terminate function */
void Vehicle_Plant_terminate(void)
{
  /* S-Function Block: <S42>/Parameter Block */
  {
    DriveSimulationData *_simdata = NULL;
    _simdata = (DriveSimulationData *) Vehicle_Plant_DWork.ParameterBlock_PWORK;
    _simdata->driveLine->time = Vehicle_Plant_M->Timing.t[0];
    _simdata->driveLine->ismajortimestep = rtmIsMajorTimeStep(Vehicle_Plant_M);
  }

  /* S-Function Block: <S42>/Kinematic Block */
  {
    DriveSimulationData *_simdata = NULL;
    _simdata = (DriveSimulationData *) Vehicle_Plant_DWork.KinematicBlock_PWORK;
    _simdata->driveLine->time = Vehicle_Plant_M->Timing.t[0];
    _simdata->driveLine->ismajortimestep = rtmIsMajorTimeStep(Vehicle_Plant_M);
  }

  /* S-Function Block: <S42>/Dynamic Block */
  {
    DriveSimulationData *_simdata = NULL;
    _simdata = (DriveSimulationData *) Vehicle_Plant_DWork.DynamicBlock_PWORK;
    _simdata->driveLine->time = Vehicle_Plant_M->Timing.t[0];
    _simdata->driveLine->ismajortimestep = rtmIsMajorTimeStep(Vehicle_Plant_M);
  }

  /* S-Function Block: <S42>/Event Block */
  {
    DriveSimulationData *_simdata = NULL;
    _simdata = (DriveSimulationData *) Vehicle_Plant_DWork.EventBlock_PWORK;
    _simdata->driveLine->time = Vehicle_Plant_M->Timing.t[0];
    _simdata->driveLine->ismajortimestep = rtmIsMajorTimeStep(Vehicle_Plant_M);
    if (driveEventSfcnTerminate(_simdata)) {
      memcpy(_simdata->driveLine->engineError, driveGetErrorMsg(), sizeof
             (DriveErrorRecord));
      _simdata->driveLine->engineError->errorFlag = true;
      rtmSetErrorStatus(Vehicle_Plant_M, _simdata->driveLine->
                        engineError->errorMsg);
      return;
    }
  }
}

/*========================================================================*
 * Start of GRT compatible call interface                                 *
 *========================================================================*/
void MdlOutputs(int_T tid)
{
  Vehicle_Plant_output(tid);
}

void MdlUpdate(int_T tid)
{
  Vehicle_Plant_update(tid);
}

void MdlInitializeSizes(void)
{
  Vehicle_Plant_M->Sizes.numContStates = (12);/* Number of continuous states */
  Vehicle_Plant_M->Sizes.numY = (8);   /* Number of model outputs */
  Vehicle_Plant_M->Sizes.numU = (8);   /* Number of model inputs */
  Vehicle_Plant_M->Sizes.sysDirFeedThru = (1);/* The model is direct feedthrough */
  Vehicle_Plant_M->Sizes.numSampTimes = (2);/* Number of sample times */
  Vehicle_Plant_M->Sizes.numBlocks = (270);/* Number of blocks */
  Vehicle_Plant_M->Sizes.numBlockIO = (51);/* Number of block outputs */
  Vehicle_Plant_M->Sizes.numBlockPrms = (1023);/* Sum of parameter "widths" */
}

void MdlInitializeSampleTimes(void)
{
}

void MdlInitialize(void)
{
  /* InitializeConditions for Integrator: '<S64>/integrator' */
  Vehicle_Plant_X.integrator_CSTATE = Vehicle_Plant_P.integrator_IC;

  /* InitializeConditions for Integrator: '<S32>/Integrator' */
  Vehicle_Plant_X.Integrator_CSTATE = Vehicle_Plant_P.Integrator_IC;

  /* InitializeConditions for Integrator: '<S60>/integrator' */
  Vehicle_Plant_X.integrator_CSTATE_k = Vehicle_Plant_P.integrator_IC_k;

  /* S-Function Block: <S42>/Parameter Block */
  {
    DriveSimulationData *_simdata = NULL;
    if (rtmIsFirstInitCond(Vehicle_Plant_M)) {
      drive_Vehicle_Plant_1_data_table *_table = NULL;
      static DriveSimulationData __simdata;
      static DriveErrorRecord __engineerror;
      DriveErrorRecord *_engineerror = &__engineerror;
      _simdata = &__simdata;
      memset(_simdata, 0, sizeof(DriveSimulationData));

      {
        static drive_Vehicle_Plant_1_data_table __table;
        _table = &__table;
      }

      memset(_table, 0, sizeof(*_table));
      _drive_Vehicle_Plant_1_drive_line = drive_Vehicle_Plant_1_drive_line
        (_table);
      _drive_Vehicle_Plant_1_drive_line->table = _table;
      _simdata->driveLine = _drive_Vehicle_Plant_1_drive_line;
      _simdata->iwork = &Vehicle_Plant_DWork.ParameterBlock_IWORK;
      _simdata->inputs[0] = (real_T *)
        Vehicle_Plant_B.TmpHiddenBufferAtParameterBlock;
      _simdata->inputs[1] = (real_T *) &Vehicle_Plant_RGND;
      _simdata->outputs[0] = (real_T *) &Vehicle_Plant_B.ParameterBlock;
      _simdata->contstates = &Vehicle_Plant_X.integrator_CSTATE;
      _simdata->dx = NULL;
      _simdata->consistencyChecking = 0;
      _simdata->abstol = NULL;
      _simdata->autoabstol = false;
      _simdata->isvarstepsolver = 0;
      _simdata->zcsignals = NULL;
      _simdata->mode = NULL;
      Vehicle_Plant_DWork.ParameterBlock_PWORK = _simdata;
      memset(_engineerror, 0, sizeof(DriveErrorRecord));
      _simdata->driveLine->engineError = _engineerror;
      _simdata->driveLine->isRTW = true;
      _simdata->driveLine->needToReadRtp = true;
      if (driveParameterSfcnInitialize(_simdata)) {
        memcpy(_simdata->driveLine->engineError, driveGetErrorMsg(), sizeof
               (DriveErrorRecord));
        _simdata->driveLine->engineError->errorFlag = true;
        rtmSetErrorStatus(Vehicle_Plant_M, _simdata->driveLine->
                          engineError->errorMsg);
        return;
      }
    } else {
      _simdata = (DriveSimulationData *)
        Vehicle_Plant_DWork.ParameterBlock_PWORK;
      _simdata->driveLine->time = Vehicle_Plant_M->Timing.t[0];
      _simdata->driveLine->ismajortimestep = rtmIsMajorTimeStep(Vehicle_Plant_M);
    }
  }

  /* S-Function Block: <S42>/Kinematic Block */
  {
    DriveSimulationData *_simdata = NULL;
    if (rtmIsFirstInitCond(Vehicle_Plant_M)) {
      static DriveSimulationData __simdata;
      _simdata = &__simdata;
      memset(_simdata, 0, sizeof(DriveSimulationData));
      _simdata->driveLine = _drive_Vehicle_Plant_1_drive_line;
      _simdata->iwork = &Vehicle_Plant_DWork.KinematicBlock_IWORK;
      _simdata->inputs[0] = (real_T *)
        Vehicle_Plant_B.TmpHiddenBufferAtDynamicBlockIn;
      _simdata->inputs[1] = (real_T *)
        Vehicle_Plant_B.TmpHiddenBufferAtKinematicBlock;
      _simdata->inputs[2] = (real_T *) &Vehicle_Plant_B.ParameterBlock;
      _simdata->outputs[0] = (real_T *) Vehicle_Plant_B.KinematicBlock_o1;
      _simdata->outputs[1] = (real_T *) Vehicle_Plant_B.KinematicBlock_o2;
      _simdata->outputs[2] = (real_T *) &Vehicle_Plant_B.KinematicBlock_o3;
      _simdata->outputs[3] = (real_T *) Vehicle_Plant_B.KinematicBlock_o4;
      _simdata->contstates = &Vehicle_Plant_X.KinematicBlock_CSTATE[0];
      _simdata->dx = NULL;
      _simdata->consistencyChecking = 0;
      _simdata->abstol = NULL;
      _simdata->autoabstol = false;
      _simdata->isvarstepsolver = 0;
      _simdata->zcsignals = NULL;
      _simdata->mode = NULL;
      Vehicle_Plant_DWork.KinematicBlock_PWORK = _simdata;
      _simdata->driveLine->numCStates = 3U;
      _simdata->driveLine->numDStates = 0U;
    } else {
      _simdata = (DriveSimulationData *)
        Vehicle_Plant_DWork.KinematicBlock_PWORK;
      _simdata->driveLine->time = Vehicle_Plant_M->Timing.t[0];
      _simdata->driveLine->ismajortimestep = rtmIsMajorTimeStep(Vehicle_Plant_M);
    }

    if (driveKinematicSfcnInitialize(_simdata)) {
      memcpy(_simdata->driveLine->engineError, driveGetErrorMsg(), sizeof
             (DriveErrorRecord));
      _simdata->driveLine->engineError->errorFlag = true;
      rtmSetErrorStatus(Vehicle_Plant_M, _simdata->driveLine->
                        engineError->errorMsg);
      return;
    }
  }

  /* InitializeConditions for Integrator: '<S3>/Integrator' */
  Vehicle_Plant_X.Integrator_CSTATE_h = Vehicle_Plant_P.Integrator_IC_b;

  /* InitializeConditions for Memory: '<S6>/Memory' */
  Vehicle_Plant_DWork.Memory_PreviousInput = Vehicle_Plant_P.Memory_X0;

  /* InitializeConditions for Memory: '<S6>/Memory1' */
  Vehicle_Plant_DWork.Memory1_PreviousInput = Vehicle_Plant_P.Memory1_X0;

  /* InitializeConditions for Memory: '<S3>/Memory' */
  Vehicle_Plant_DWork.Memory_PreviousInput_n = Vehicle_Plant_P.Memory_X0_e;

  /* InitializeConditions for Memory: '<S3>/Memory1' */
  Vehicle_Plant_DWork.Memory1_PreviousInput_k = Vehicle_Plant_P.Memory1_X0_k;

  /* InitializeConditions for Memory: '<S4>/Memory1' */
  Vehicle_Plant_DWork.Memory1_PreviousInput_j = Vehicle_Plant_P.Memory1_X0_h;

  /* InitializeConditions for Memory: '<S4>/Memory' */
  Vehicle_Plant_DWork.Memory_PreviousInput_m = Vehicle_Plant_P.Memory_X0_o;

  /* InitializeConditions for DiscreteIntegrator: '<S1>/Discrete-Time Integrator' */
  Vehicle_Plant_DWork.DiscreteTimeIntegrator_DSTATE =
    Vehicle_Plant_P.DiscreteTimeIntegrator_IC;

  /* InitializeConditions for RateLimiter: '<S3>/Rate Limiter' */
  Vehicle_Plant_DWork.LastMajorTime = (rtInf);

  /* InitializeConditions for Integrator: '<S5>/Integrator' */
  Vehicle_Plant_X.Integrator_CSTATE_e = Vehicle_Plant_P.Integrator_IC_l;

  /* TransferFcn Block: '<S5>/Transfer Fcn' */
  Vehicle_Plant_X.TransferFcn_CSTATE = 0.0;

  /* InitializeConditions for RateLimiter: '<S30>/Brake Slew Rate (.25 s)' */
  Vehicle_Plant_DWork.LastMajorTime_n = (rtInf);

  /* InitializeConditions for RateLimiter: '<S30>/Rate Limiter 10, -10' */
  Vehicle_Plant_DWork.LastMajorTime_a = (rtInf);

  /* InitializeConditions for RateLimiter: '<S31>/Brake Slew Rate (.25 s)' */
  Vehicle_Plant_DWork.LastMajorTime_o = (rtInf);

  /* InitializeConditions for RateLimiter: '<S31>/Rate Limiter 10, -10' */
  Vehicle_Plant_DWork.LastMajorTime_d = (rtInf);

  /* InitializeConditions for Integrator: '<S7>/Integrator' */
  Vehicle_Plant_X.Integrator_CSTATE_a = Vehicle_Plant_P.Integrator_IC_g;

  /* S-Function Block: <S42>/Dynamic Block */
  {
    DriveSimulationData *_simdata = NULL;
    if (rtmIsFirstInitCond(Vehicle_Plant_M)) {
      static DriveSimulationData __simdata;
      _simdata = &__simdata;
      memset(_simdata, 0, sizeof(DriveSimulationData));
      _simdata->driveLine = _drive_Vehicle_Plant_1_drive_line;
      _simdata->iwork = &Vehicle_Plant_DWork.DynamicBlock_IWORK;
      _simdata->inputs[0] = (real_T *)
        Vehicle_Plant_B.TmpHiddenBufferAtDynamicBlockIn;
      _simdata->inputs[1] = (real_T *) Vehicle_Plant_B.KinematicBlock_o1;
      _simdata->inputs[2] = (real_T *) Vehicle_Plant_B.KinematicBlock_o2;
      _simdata->inputs[3] = (real_T *) &Vehicle_Plant_B.KinematicBlock_o3;
      _simdata->outputs[0] = (real_T *) &Vehicle_Plant_B.DynamicBlock_o1;
      _simdata->outputs[1] = (real_T *) Vehicle_Plant_B.DynamicBlock_o2;
      _simdata->contstates = &Vehicle_Plant_X.integrator_CSTATE;
      _simdata->dx = NULL;
      _simdata->consistencyChecking = 0;
      _simdata->abstol = NULL;
      _simdata->autoabstol = false;
      _simdata->isvarstepsolver = 0;
      _simdata->zcsignals = NULL;
      _simdata->mode = NULL;
      Vehicle_Plant_DWork.DynamicBlock_PWORK = _simdata;
    } else {
      _simdata = (DriveSimulationData *) Vehicle_Plant_DWork.DynamicBlock_PWORK;
      _simdata->driveLine->time = Vehicle_Plant_M->Timing.t[0];
      _simdata->driveLine->ismajortimestep = rtmIsMajorTimeStep(Vehicle_Plant_M);
    }
  }

  /* TransferFcn Block: '<S32>/Transfer Fcn1' */
  Vehicle_Plant_X.TransferFcn1_CSTATE[0] = 0.0;
  Vehicle_Plant_X.TransferFcn1_CSTATE[1] = 0.0;

  /* S-Function Block: <S42>/Event Block */
  {
    DriveSimulationData *_simdata = NULL;
    if (rtmIsFirstInitCond(Vehicle_Plant_M)) {
      static DriveSimulationData __simdata;
      _simdata = &__simdata;
      memset(_simdata, 0, sizeof(DriveSimulationData));
      _simdata->driveLine = _drive_Vehicle_Plant_1_drive_line;
      _simdata->iwork = &Vehicle_Plant_DWork.EventBlock_IWORK;
      _simdata->inputs[0] = (real_T *) &Vehicle_Plant_B.DynamicBlock_o1;
      _simdata->outputs[0] = (real_T *) &Vehicle_Plant_B.EventBlock;
      _simdata->contstates = &Vehicle_Plant_X.integrator_CSTATE;
      _simdata->dx = NULL;
      _simdata->consistencyChecking = 0;
      _simdata->abstol = NULL;
      _simdata->autoabstol = false;
      _simdata->isvarstepsolver = 0;
      _simdata->zcsignals = NULL;
      _simdata->mode = NULL;
      Vehicle_Plant_DWork.EventBlock_PWORK = _simdata;
    } else {
      _simdata = (DriveSimulationData *) Vehicle_Plant_DWork.EventBlock_PWORK;
      _simdata->driveLine->time = Vehicle_Plant_M->Timing.t[0];
      _simdata->driveLine->ismajortimestep = rtmIsMajorTimeStep(Vehicle_Plant_M);
    }

    if (driveEventSfcnInitialize(_simdata)) {
      memcpy(_simdata->driveLine->engineError, driveGetErrorMsg(), sizeof
             (DriveErrorRecord));
      _simdata->driveLine->engineError->errorFlag = true;
      rtmSetErrorStatus(Vehicle_Plant_M, _simdata->driveLine->
                        engineError->errorMsg);
      return;
    }
  }

  /* set "at time zero" to false */
  if (rtmIsFirstInitCond(Vehicle_Plant_M)) {
    rtmSetFirstInitCond(Vehicle_Plant_M, 0);
  }
}

void MdlStart(void)
{
  MdlInitialize();
}

RT_MODEL_Vehicle_Plant *Vehicle_Plant(void)
{
  Vehicle_Plant_initialize(1);
  return Vehicle_Plant_M;
}

void MdlTerminate(void)
{
  Vehicle_Plant_terminate();
}

/*========================================================================*
 * End of GRT compatible call interface                                   *
 *========================================================================*/

/*
   This file contains automatically generated code for functions
   to update the inports and outports of a Simulink/Realtime Workshop
   model. Calls to these functions should be made before each step is taken
   (inports, call SetExternalInputs) and after each step is taken
   (outports, call SetExternalOutputs.)
 */
#ifdef NI_ROOTMODEL_Vehicle_Plant
#include "model_info.h"
#include "SIT_API.h"
#include <stddef.h>
#include <stdlib.h>
#include <float.h>

double NIRT_GetValueByDataType(void* ptr,int subindex, int type, int Complex)
{
  switch (type)
  {
   case 0:
    return (double)(((real_T *)ptr)[subindex]);

   case 1:
    return (double)(((real32_T *)ptr)[subindex]);

   case 2:
    return (double)(((int8_T *)ptr)[subindex]);

   case 3:
    return (double)(((uint8_T *)ptr)[subindex]);

   case 4:
    return (double)(((int16_T *)ptr)[subindex]);

   case 5:
    return (double)(((uint16_T *)ptr)[subindex]);

   case 6:
    return (double)(((int32_T *)ptr)[subindex]);

   case 7:
    return (double)(((uint32_T *)ptr)[subindex]);

   case 8:
    return (double)(((boolean_T *)ptr)[subindex]);

   case 10:
    //Type is renamed. Call GetValueByDataType on its contained type
    return NIRT_GetValueByDataType(ptr,subindex,6,Complex);

   case 13:
    //Type is array. Call GetValueByDataType on its contained type
    return NIRT_GetValueByDataType(ptr,subindex,7,Complex);

   case 16:
    //Type is renamed. Call GetValueByDataType on its contained type
    return NIRT_GetValueByDataType(ptr,subindex,3,Complex);

   case 17:
    //Type is matrix. Call GetValueByDataType on its contained type
    return NIRT_GetValueByDataType(ptr,subindex,0,Complex);

   case 18:
    //Type is matrix. Call GetValueByDataType on its contained type
    return NIRT_GetValueByDataType(ptr,subindex,0,Complex);

   case 19:
    //Type is matrix. Call GetValueByDataType on its contained type
    return NIRT_GetValueByDataType(ptr,subindex,0,Complex);

   case 20:
    //Type is matrix. Call GetValueByDataType on its contained type
    return NIRT_GetValueByDataType(ptr,subindex,0,Complex);

   case 21:
    //Type is matrix. Call GetValueByDataType on its contained type
    return NIRT_GetValueByDataType(ptr,subindex,0,Complex);

   case 22:
    //Type is matrix. Call GetValueByDataType on its contained type
    return NIRT_GetValueByDataType(ptr,subindex,0,Complex);

   case 23:
    //Type is matrix. Call GetValueByDataType on its contained type
    return NIRT_GetValueByDataType(ptr,subindex,0,Complex);

   case 24:
    //Type is matrix. Call GetValueByDataType on its contained type
    return NIRT_GetValueByDataType(ptr,subindex,0,Complex);

   case 25:
    //Type is matrix. Call GetValueByDataType on its contained type
    return NIRT_GetValueByDataType(ptr,subindex,0,Complex);

   case 26:
    //Type is matrix. Call GetValueByDataType on its contained type
    return NIRT_GetValueByDataType(ptr,subindex,0,Complex);

   case 27:
    //Type is matrix. Call GetValueByDataType on its contained type
    return NIRT_GetValueByDataType(ptr,subindex,0,Complex);

   case 28:
    //Type is matrix. Call GetValueByDataType on its contained type
    return NIRT_GetValueByDataType(ptr,subindex,0,Complex);

   case 29:
    //Type is matrix. Call GetValueByDataType on its contained type
    return NIRT_GetValueByDataType(ptr,subindex,0,Complex);

   case 30:
    //Type is matrix. Call GetValueByDataType on its contained type
    return NIRT_GetValueByDataType(ptr,subindex,0,Complex);

   case 31:
    //Type is matrix. Call GetValueByDataType on its contained type
    return NIRT_GetValueByDataType(ptr,subindex,0,Complex);

   case 32:
    //Type is matrix. Call GetValueByDataType on its contained type
    return NIRT_GetValueByDataType(ptr,subindex,0,Complex);

   case 33:
    //Type is matrix. Call GetValueByDataType on its contained type
    return NIRT_GetValueByDataType(ptr,subindex,8,Complex);

   case 34:
    //Type is matrix. Call GetValueByDataType on its contained type
    return NIRT_GetValueByDataType(ptr,subindex,8,Complex);

   case 43:
    //Type is matrix. Call GetValueByDataType on its contained type
    return NIRT_GetValueByDataType(ptr,subindex,0,Complex);

   case 44:
    //Type is matrix. Call GetValueByDataType on its contained type
    return NIRT_GetValueByDataType(ptr,subindex,0,Complex);

   case 45:
    //Type is matrix. Call GetValueByDataType on its contained type
    return NIRT_GetValueByDataType(ptr,subindex,0,Complex);

   case 46:
    //Type is matrix. Call GetValueByDataType on its contained type
    return NIRT_GetValueByDataType(ptr,subindex,0,Complex);

   case 47:
    //Type is matrix. Call GetValueByDataType on its contained type
    return NIRT_GetValueByDataType(ptr,subindex,0,Complex);

   case 48:
    //Type is matrix. Call GetValueByDataType on its contained type
    return NIRT_GetValueByDataType(ptr,subindex,0,Complex);

   case 49:
    //Type is matrix. Call GetValueByDataType on its contained type
    return NIRT_GetValueByDataType(ptr,subindex,0,Complex);

   case 50:
    //Type is matrix. Call GetValueByDataType on its contained type
    return NIRT_GetValueByDataType(ptr,subindex,0,Complex);

   case 51:
    //Type is matrix. Call GetValueByDataType on its contained type
    return NIRT_GetValueByDataType(ptr,subindex,0,Complex);

   case 52:
    //Type is matrix. Call GetValueByDataType on its contained type
    return NIRT_GetValueByDataType(ptr,subindex,0,Complex);

   case 53:
    //Type is matrix. Call GetValueByDataType on its contained type
    return NIRT_GetValueByDataType(ptr,subindex,0,Complex);

   case 54:
    //Type is matrix. Call GetValueByDataType on its contained type
    return NIRT_GetValueByDataType(ptr,subindex,0,Complex);

   case 55:
    //Type is matrix. Call GetValueByDataType on its contained type
    return NIRT_GetValueByDataType(ptr,subindex,0,Complex);

   case 56:
    //Type is matrix. Call GetValueByDataType on its contained type
    return NIRT_GetValueByDataType(ptr,subindex,0,Complex);

   case 57:
    //Type is matrix. Call GetValueByDataType on its contained type
    return NIRT_GetValueByDataType(ptr,subindex,0,Complex);

   case 58:
    //Type is matrix. Call GetValueByDataType on its contained type
    return NIRT_GetValueByDataType(ptr,subindex,3,Complex);
  }

  // return ((double *)ptr)[subindex];
  return rtNaN;
}

long NIRT_SetValueByDataType(void* ptr,int subindex, double value, int type, int
  Complex)
{
  //Complex is only used for R14.3 and down
  switch (type)
  {
   case 0:
    ((real_T *)ptr)[subindex] = (real_T)value;
    return NI_OK;

   case 1:
    ((real32_T *)ptr)[subindex] = (real32_T)value;
    return NI_OK;

   case 2:
    ((int8_T *)ptr)[subindex] = (int8_T)value;
    return NI_OK;

   case 3:
    ((uint8_T *)ptr)[subindex] = (uint8_T)value;
    return NI_OK;

   case 4:
    ((int16_T *)ptr)[subindex] = (int16_T)value;
    return NI_OK;

   case 5:
    ((uint16_T *)ptr)[subindex] = (uint16_T)value;
    return NI_OK;

   case 6:
    ((int32_T *)ptr)[subindex] = (int32_T)value;
    return NI_OK;

   case 7:
    ((uint32_T *)ptr)[subindex] = (uint32_T)value;
    return NI_OK;

   case 8:
    ((boolean_T *)ptr)[subindex] = (boolean_T)value;
    return NI_OK;

   case 10:
    //Type is renamed. Call SetValueByDataType on its contained type
    return NIRT_SetValueByDataType(ptr,subindex,value,6,Complex);

   case 13:
    //Type is array. Call SetValueByDataType on its contained type
    return NIRT_SetValueByDataType(ptr,subindex,value,7,Complex);

   case 16:
    //Type is renamed. Call SetValueByDataType on its contained type
    return NIRT_SetValueByDataType(ptr,subindex,value,3,Complex);

   case 17:
    //Type is matrix. Call SetValueByDataType on its contained type
    return NIRT_SetValueByDataType(ptr,subindex,value,0,Complex);

   case 18:
    //Type is matrix. Call SetValueByDataType on its contained type
    return NIRT_SetValueByDataType(ptr,subindex,value,0,Complex);

   case 19:
    //Type is matrix. Call SetValueByDataType on its contained type
    return NIRT_SetValueByDataType(ptr,subindex,value,0,Complex);

   case 20:
    //Type is matrix. Call SetValueByDataType on its contained type
    return NIRT_SetValueByDataType(ptr,subindex,value,0,Complex);

   case 21:
    //Type is matrix. Call SetValueByDataType on its contained type
    return NIRT_SetValueByDataType(ptr,subindex,value,0,Complex);

   case 22:
    //Type is matrix. Call SetValueByDataType on its contained type
    return NIRT_SetValueByDataType(ptr,subindex,value,0,Complex);

   case 23:
    //Type is matrix. Call SetValueByDataType on its contained type
    return NIRT_SetValueByDataType(ptr,subindex,value,0,Complex);

   case 24:
    //Type is matrix. Call SetValueByDataType on its contained type
    return NIRT_SetValueByDataType(ptr,subindex,value,0,Complex);

   case 25:
    //Type is matrix. Call SetValueByDataType on its contained type
    return NIRT_SetValueByDataType(ptr,subindex,value,0,Complex);

   case 26:
    //Type is matrix. Call SetValueByDataType on its contained type
    return NIRT_SetValueByDataType(ptr,subindex,value,0,Complex);

   case 27:
    //Type is matrix. Call SetValueByDataType on its contained type
    return NIRT_SetValueByDataType(ptr,subindex,value,0,Complex);

   case 28:
    //Type is matrix. Call SetValueByDataType on its contained type
    return NIRT_SetValueByDataType(ptr,subindex,value,0,Complex);

   case 29:
    //Type is matrix. Call SetValueByDataType on its contained type
    return NIRT_SetValueByDataType(ptr,subindex,value,0,Complex);

   case 30:
    //Type is matrix. Call SetValueByDataType on its contained type
    return NIRT_SetValueByDataType(ptr,subindex,value,0,Complex);

   case 31:
    //Type is matrix. Call SetValueByDataType on its contained type
    return NIRT_SetValueByDataType(ptr,subindex,value,0,Complex);

   case 32:
    //Type is matrix. Call SetValueByDataType on its contained type
    return NIRT_SetValueByDataType(ptr,subindex,value,0,Complex);

   case 33:
    //Type is matrix. Call SetValueByDataType on its contained type
    return NIRT_SetValueByDataType(ptr,subindex,value,8,Complex);

   case 34:
    //Type is matrix. Call SetValueByDataType on its contained type
    return NIRT_SetValueByDataType(ptr,subindex,value,8,Complex);

   case 43:
    //Type is matrix. Call SetValueByDataType on its contained type
    return NIRT_SetValueByDataType(ptr,subindex,value,0,Complex);

   case 44:
    //Type is matrix. Call SetValueByDataType on its contained type
    return NIRT_SetValueByDataType(ptr,subindex,value,0,Complex);

   case 45:
    //Type is matrix. Call SetValueByDataType on its contained type
    return NIRT_SetValueByDataType(ptr,subindex,value,0,Complex);

   case 46:
    //Type is matrix. Call SetValueByDataType on its contained type
    return NIRT_SetValueByDataType(ptr,subindex,value,0,Complex);

   case 47:
    //Type is matrix. Call SetValueByDataType on its contained type
    return NIRT_SetValueByDataType(ptr,subindex,value,0,Complex);

   case 48:
    //Type is matrix. Call SetValueByDataType on its contained type
    return NIRT_SetValueByDataType(ptr,subindex,value,0,Complex);

   case 49:
    //Type is matrix. Call SetValueByDataType on its contained type
    return NIRT_SetValueByDataType(ptr,subindex,value,0,Complex);

   case 50:
    //Type is matrix. Call SetValueByDataType on its contained type
    return NIRT_SetValueByDataType(ptr,subindex,value,0,Complex);

   case 51:
    //Type is matrix. Call SetValueByDataType on its contained type
    return NIRT_SetValueByDataType(ptr,subindex,value,0,Complex);

   case 52:
    //Type is matrix. Call SetValueByDataType on its contained type
    return NIRT_SetValueByDataType(ptr,subindex,value,0,Complex);

   case 53:
    //Type is matrix. Call SetValueByDataType on its contained type
    return NIRT_SetValueByDataType(ptr,subindex,value,0,Complex);

   case 54:
    //Type is matrix. Call SetValueByDataType on its contained type
    return NIRT_SetValueByDataType(ptr,subindex,value,0,Complex);

   case 55:
    //Type is matrix. Call SetValueByDataType on its contained type
    return NIRT_SetValueByDataType(ptr,subindex,value,0,Complex);

   case 56:
    //Type is matrix. Call SetValueByDataType on its contained type
    return NIRT_SetValueByDataType(ptr,subindex,value,0,Complex);

   case 57:
    //Type is matrix. Call SetValueByDataType on its contained type
    return NIRT_SetValueByDataType(ptr,subindex,value,0,Complex);

   case 58:
    //Type is matrix. Call SetValueByDataType on its contained type
    return NIRT_SetValueByDataType(ptr,subindex,value,3,Complex);
  }

  //No matching datatype conversion
  return NI_ERROR;
}

extern Vehicle_Plant_rtModel *S;
extern _SITexportglobals SITexportglobals;
void SetExternalInputs(double* data, int* TaskSampleHit)
{
  int index = 0, count = 0;
  ExternalInputs_Vehicle_Plant *rtIN = (ExternalInputs_Vehicle_Plant*)
    S->ModelData.inputs;

  /* rtIN->Generator_Torque Type 0 Width 1 */
  if (TaskSampleHit[0]) {              // sample and hold
    NIRT_SetValueByDataType(&rtIN->Generator_Torque, 0, data[index++], 0, 0);
  } else {                             // hold this input--skip over it in the input buffer
    index += 1;
  }

  /* rtIN->Engine_On Type 0 Width 1 */
  if (TaskSampleHit[0]) {              // sample and hold
    NIRT_SetValueByDataType(&rtIN->Engine_On, 0, data[index++], 0, 0);
  } else {                             // hold this input--skip over it in the input buffer
    index += 1;
  }

  /* rtIN->Engine_Throttle Type 0 Width 1 */
  if (TaskSampleHit[0]) {              // sample and hold
    NIRT_SetValueByDataType(&rtIN->Engine_Throttle, 0, data[index++], 0, 0);
  } else {                             // hold this input--skip over it in the input buffer
    index += 1;
  }

  /* rtIN->Motor_Torque_Request Type 0 Width 1 */
  if (TaskSampleHit[0]) {              // sample and hold
    NIRT_SetValueByDataType(&rtIN->Motor_Torque_Request, 0, data[index++], 0, 0);
  } else {                             // hold this input--skip over it in the input buffer
    index += 1;
  }

  /* rtIN->Brake_Request Type 0 Width 1 */
  if (TaskSampleHit[0]) {              // sample and hold
    NIRT_SetValueByDataType(&rtIN->Brake_Request, 0, data[index++], 0, 0);
  } else {                             // hold this input--skip over it in the input buffer
    index += 1;
  }

  /* rtIN->Battery_Connect_Command Type 0 Width 1 */
  if (TaskSampleHit[0]) {              // sample and hold
    NIRT_SetValueByDataType(&rtIN->Battery_Connect_Command, 0, data[index++], 0,
      0);
  } else {                             // hold this input--skip over it in the input buffer
    index += 1;
  }

  /* rtIN->Gen_Enable Type 0 Width 1 */
  if (TaskSampleHit[1]) {              // sample and hold
    NIRT_SetValueByDataType(&rtIN->Gen_Enable, 0, data[index++], 0, 0);
  } else {                             // hold this input--skip over it in the input buffer
    index += 1;
  }

  /* rtIN->Motor_Enable Type 0 Width 1 */
  if (TaskSampleHit[1]) {              // sample and hold
    NIRT_SetValueByDataType(&rtIN->Motor_Enable, 0, data[index++], 0, 0);
  } else {                             // hold this input--skip over it in the input buffer
    index += 1;
  }
}                                      /* of SetExternalInputs */

long NumInputPorts(void)
{
  return 8;
}

double ni_extout[8];
void SetExternalOutputs(double* data, int* TaskSampleHit)
{
  int index = 0, count = 0;
  ExternalOutputs_Vehicle_Plant* rtOUT = (ExternalOutputs_Vehicle_Plant*)
    S->ModelData.outputs;

  /* rtOUT->Measured_Engine_rpm has width 1 type 0 */
  if (TaskSampleHit[0]) {              // sample and hold
    ni_extout[index++] = NIRT_GetValueByDataType(&(rtOUT->Measured_Engine_rpm),0,
      0,0);
  } else {
    index += 1;
  }

  /* rtOUT->Battery_SOC has width 1 type 0 */
  if (TaskSampleHit[0]) {              // sample and hold
    ni_extout[index++] = NIRT_GetValueByDataType(&(rtOUT->Battery_SOC),0,0,0);
  } else {
    index += 1;
  }

  /* rtOUT->Generator_Current_A has width 1 type 0 */
  if (TaskSampleHit[0]) {              // sample and hold
    ni_extout[index++] = NIRT_GetValueByDataType(&(rtOUT->Generator_Current_A),0,
      0,0);
  } else {
    index += 1;
  }

  /* rtOUT->Battery_Pack_State has width 1 type 0 */
  if (TaskSampleHit[1]) {              // sample and hold
    ni_extout[index++] = NIRT_GetValueByDataType(&(rtOUT->Battery_Pack_State),0,
      0,0);
  } else {
    index += 1;
  }

  /* rtOUT->Motor_State has width 1 type 0 */
  if (TaskSampleHit[0]) {              // sample and hold
    ni_extout[index++] = NIRT_GetValueByDataType(&(rtOUT->Motor_State),0,0,0);
  } else {
    index += 1;
  }

  /* rtOUT->Gen_State has width 1 type 0 */
  if (TaskSampleHit[0]) {              // sample and hold
    ni_extout[index++] = NIRT_GetValueByDataType(&(rtOUT->Gen_State),0,0,0);
  } else {
    index += 1;
  }

  /* rtOUT->Motor_Current_A has width 1 type 0 */
  if (TaskSampleHit[0]) {              // sample and hold
    ni_extout[index++] = NIRT_GetValueByDataType(&(rtOUT->Motor_Current_A),0,0,0);
  } else {
    index += 1;
  }

  /* rtOUT->Motor_rpm has width 1 type 0 */
  if (TaskSampleHit[0]) {              // sample and hold
    ni_extout[index++] = NIRT_GetValueByDataType(&(rtOUT->Motor_rpm),0,0,0);
  } else {
    index += 1;
  }

  if (data)
    memcpy(&data[0], &ni_extout[0], sizeof(ni_extout));
}

long NumOutputPorts(void)
{
  return 8;
}

int NI_InitExternalOutputs()
{
  int index = 0, count = 0;
  ExternalOutputs_Vehicle_Plant* rtOUT = (ExternalOutputs_Vehicle_Plant*)
    S->ModelData.outputs;

  /* rtOUT->Measured_Engine_rpm has width 1 type 0 */
  ni_extout[index++] = NIRT_GetValueByDataType(&(rtOUT->Measured_Engine_rpm),0,0,
    0);

  /* rtOUT->Battery_SOC has width 1 type 0 */
  ni_extout[index++] = NIRT_GetValueByDataType(&(rtOUT->Battery_SOC),0,0,0);

  /* rtOUT->Generator_Current_A has width 1 type 0 */
  ni_extout[index++] = NIRT_GetValueByDataType(&(rtOUT->Generator_Current_A),0,0,
    0);

  /* rtOUT->Battery_Pack_State has width 1 type 0 */
  ni_extout[index++] = NIRT_GetValueByDataType(&(rtOUT->Battery_Pack_State),0,0,
    0);

  /* rtOUT->Motor_State has width 1 type 0 */
  ni_extout[index++] = NIRT_GetValueByDataType(&(rtOUT->Motor_State),0,0,0);

  /* rtOUT->Gen_State has width 1 type 0 */
  ni_extout[index++] = NIRT_GetValueByDataType(&(rtOUT->Gen_State),0,0,0);

  /* rtOUT->Motor_Current_A has width 1 type 0 */
  ni_extout[index++] = NIRT_GetValueByDataType(&(rtOUT->Motor_Current_A),0,0,0);

  /* rtOUT->Motor_rpm has width 1 type 0 */
  ni_extout[index++] = NIRT_GetValueByDataType(&(rtOUT->Motor_rpm),0,0,0);
  return NI_OK;
}

// by default, all elements (inclulding	scalars) have 2 dimensions [1,1]
static NI_Parameter NI_ParamList[] = {
  { 0,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/RHIT Tire1/Motion Actuator1/integrator/InitialCondition",
    offsetof(Parameters_Vehicle_Plant, integrator_IC), 43, 1, 2, 0, "", 0 },

  { 1,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Longitudinal Vehicle Dynamics/Integrator/InitialCondition",
    offsetof(Parameters_Vehicle_Plant, Integrator_IC), 43, 1, 2, 2, "", 0 },

  { 2, "vehicle_plant/Vehicle_Plant/Rear Diff and Body/RHIT Tire1/Gain1/Gain",
    offsetof(Parameters_Vehicle_Plant, Gain1_Gain), 43, 1, 2, 4, "", 0 },

  { 3,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/RHIT Tire1/Constant2/Value",
    offsetof(Parameters_Vehicle_Plant, Constant2_Value), 43, 1, 2, 6, "", 0 },

  { 4,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/RHIT Tire/Motion Actuator1/integrator/InitialCondition",
    offsetof(Parameters_Vehicle_Plant, integrator_IC_k), 43, 1, 2, 8, "", 0 },

  { 5, "vehicle_plant/Vehicle_Plant/Rear Diff and Body/RHIT Tire/Gain1/Gain",
    offsetof(Parameters_Vehicle_Plant, Gain1_Gain_e), 43, 1, 2, 10, "", 0 },

  { 6,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/RHIT Tire/Constant2/Value",
    offsetof(Parameters_Vehicle_Plant, Constant2_Value_g), 43, 1, 2, 12, "", 0 },

  { 7,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Passenger Half-shaft/Inertia/Value",
    offsetof(Parameters_Vehicle_Plant, Inertia_Value), 43, 1, 2, 14, "", 0 },

  { 8,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Passenger Half-shaft/InitialCondition/Value",
    offsetof(Parameters_Vehicle_Plant, InitialCondition_Value), 43, 1, 2, 16, "",
    0 },

  { 9,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Differential 3.73:1 ratio/Simple Gear3/GearRatio/Value",
    offsetof(Parameters_Vehicle_Plant, GearRatio_Value), 43, 1, 2, 18, "", 0 },

  { 10,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Differential 3.73:1 ratio/Planet-Planet/PlanetPlanetRatio/Value",
    offsetof(Parameters_Vehicle_Plant, PlanetPlanetRatio_Value), 43, 1, 2, 20,
    "", 0 },

  { 11,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Differential 3.73:1 ratio/Planet-Planet1/PlanetPlanetRatio/Value",
    offsetof(Parameters_Vehicle_Plant, PlanetPlanetRatio_Value_d), 43, 1, 2, 22,
    "", 0 },

  { 12,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Differential 3.73:1 ratio/Simple Gear/GearRatio/Value",
    offsetof(Parameters_Vehicle_Plant, GearRatio_Value_d), 43, 1, 2, 24, "", 0 },

  { 13,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Differential 3.73:1 ratio/Simple Gear2/GearRatio/Value",
    offsetof(Parameters_Vehicle_Plant, GearRatio_Value_l), 43, 1, 2, 26, "", 0 },

  { 14,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Driver Half-shaft/Inertia/Value",
    offsetof(Parameters_Vehicle_Plant, Inertia_Value_i), 43, 1, 2, 28, "", 0 },

  { 15,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Driver Half-shaft/InitialCondition/Value",
    offsetof(Parameters_Vehicle_Plant, InitialCondition_Value_m), 43, 1, 2, 30,
    "", 0 },

  { 16,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Differential 3.73:1 ratio/Simple Gear1/GearRatio/Value",
    offsetof(Parameters_Vehicle_Plant, GearRatio_Value_j), 43, 1, 2, 32, "", 0 },

  { 17, "vehicle_plant/Vehicle_Plant/Engine/Engine/Inertia/Value", offsetof
    (Parameters_Vehicle_Plant, Inertia_Value_k), 43, 1, 2, 34, "", 0 },

  { 18, "vehicle_plant/Vehicle_Plant/Engine/Engine/InitialCondition/Value",
    offsetof(Parameters_Vehicle_Plant, InitialCondition_Value_b), 43, 1, 2, 36,
    "", 0 },

  { 19, "vehicle_plant/Vehicle_Plant/Generator/Inertia/Inertia/Value", offsetof
    (Parameters_Vehicle_Plant, Inertia_Value_a), 43, 1, 2, 38, "", 0 },

  { 20, "vehicle_plant/Vehicle_Plant/Generator/Inertia/InitialCondition/Value",
    offsetof(Parameters_Vehicle_Plant, InitialCondition_Value_e), 43, 1, 2, 40,
    "", 0 },

  { 21, "vehicle_plant/Vehicle_Plant/Electric_Motor/Inertia/Inertia/Value",
    offsetof(Parameters_Vehicle_Plant, Inertia_Value_b), 43, 1, 2, 42, "", 0 },

  { 22,
    "vehicle_plant/Vehicle_Plant/Electric_Motor/Inertia/InitialCondition/Value",
    offsetof(Parameters_Vehicle_Plant, InitialCondition_Value_a), 43, 1, 2, 44,
    "", 0 },

  { 23, "vehicle_plant/Vehicle_Plant/Engine/Motion Sensor/Gain V/Gain", offsetof
    (Parameters_Vehicle_Plant, GainV_Gain), 43, 1, 2, 46, "", 0 },

  { 24, "vehicle_plant/Vehicle_Plant/Engine/rad to rpm/Gain", offsetof
    (Parameters_Vehicle_Plant, radtorpm_Gain), 43, 1, 2, 48, "", 0 },

  { 25, "vehicle_plant/Vehicle_Plant/Battery/Integrator/InitialCondition",
    offsetof(Parameters_Vehicle_Plant, Integrator_IC_b), 43, 1, 2, 50, "", 0 },

  { 26, "vehicle_plant/Vehicle_Plant/Battery/Gain/Gain", offsetof
    (Parameters_Vehicle_Plant, Gain_Gain), 43, 1, 2, 52, "", 0 },

  { 27, "vehicle_plant/Vehicle_Plant/Battery/Constant2/Value", offsetof
    (Parameters_Vehicle_Plant, Constant2_Value_a), 43, 1, 2, 54, "", 0 },

  { 28, "vehicle_plant/Vehicle_Plant/Battery/Constant3/Value", offsetof
    (Parameters_Vehicle_Plant, Constant3_Value), 43, 1, 2, 56, "", 0 },

  { 29, "vehicle_plant/Vehicle_Plant/Generator/Motion Sensor/Gain V/Gain",
    offsetof(Parameters_Vehicle_Plant, GainV_Gain_b), 43, 1, 2, 58, "", 0 },

  { 30, "vehicle_plant/Vehicle_Plant/Generator/Gain1/Gain", offsetof
    (Parameters_Vehicle_Plant, Gain1_Gain_o), 43, 1, 2, 60, "", 0 },

  { 31, "vehicle_plant/Vehicle_Plant/Generator/Memory/X0", offsetof
    (Parameters_Vehicle_Plant, Memory_X0), 43, 1, 2, 62, "", 0 },

  { 32, "vehicle_plant/Vehicle_Plant/Generator/Lookup Table (2-D)/RowIndex",
    offsetof(Parameters_Vehicle_Plant, LookupTable2D_RowIdx), 44, 21, 2, 64, "",
    0 },

  { 33, "vehicle_plant/Vehicle_Plant/Generator/Lookup Table (2-D)/ColumnIndex",
    offsetof(Parameters_Vehicle_Plant, LookupTable2D_ColIdx), 45, 10, 2, 66, "",
    0 },

  { 34, "vehicle_plant/Vehicle_Plant/Generator/Lookup Table (2-D)/Table",
    offsetof(Parameters_Vehicle_Plant, LookupTable2D_Table), 46, 210, 2, 68, "",
    0 },

  { 35, "vehicle_plant/Vehicle_Plant/Generator/Lookup Table/InputValues",
    offsetof(Parameters_Vehicle_Plant, LookupTable_XData), 47, 16, 2, 70, "", 0
  },

  { 36, "vehicle_plant/Vehicle_Plant/Generator/Lookup Table/Table", offsetof
    (Parameters_Vehicle_Plant, LookupTable_YData), 47, 16, 2, 72, "", 0 },

  { 37, "vehicle_plant/Vehicle_Plant/Generator/Memory1/X0", offsetof
    (Parameters_Vehicle_Plant, Memory1_X0), 43, 1, 2, 74, "", 0 },

  { 38, "vehicle_plant/Vehicle_Plant/Battery/Battery Temperature1/Value",
    offsetof(Parameters_Vehicle_Plant, BatteryTemperature1_Value), 43, 1, 2, 76,
    "", 0 },

  { 39, "vehicle_plant/Vehicle_Plant/Battery/Battery Temperature/Value",
    offsetof(Parameters_Vehicle_Plant, BatteryTemperature_Value), 43, 1, 2, 78,
    "", 0 },

  { 40, "vehicle_plant/Vehicle_Plant/Battery/Memory/X0", offsetof
    (Parameters_Vehicle_Plant, Memory_X0_e), 43, 1, 2, 80, "", 0 },

  { 41, "vehicle_plant/Vehicle_Plant/Battery/Memory1/X0", offsetof
    (Parameters_Vehicle_Plant, Memory1_X0_k), 43, 1, 2, 82, "", 0 },

  { 42, "vehicle_plant/Vehicle_Plant/Battery/Constant1/Value", offsetof
    (Parameters_Vehicle_Plant, Constant1_Value), 43, 1, 2, 84, "", 0 },

  { 43, "vehicle_plant/Vehicle_Plant/Battery/Switch1/Threshold", offsetof
    (Parameters_Vehicle_Plant, Switch1_Threshold), 43, 1, 2, 86, "", 0 },

  { 44, "vehicle_plant/Vehicle_Plant/Generator/Constant1/Value", offsetof
    (Parameters_Vehicle_Plant, Constant1_Value_n), 43, 1, 2, 88, "", 0 },

  { 45, "vehicle_plant/Vehicle_Plant/Generator/Switch1/Threshold", offsetof
    (Parameters_Vehicle_Plant, Switch1_Threshold_o), 43, 1, 2, 90, "", 0 },

  { 46, "vehicle_plant/Vehicle_Plant/Generator/Constant/Value", offsetof
    (Parameters_Vehicle_Plant, Constant_Value), 43, 1, 2, 92, "", 0 },

  { 47, "vehicle_plant/Vehicle_Plant/Generator/Switch/Threshold", offsetof
    (Parameters_Vehicle_Plant, Switch_Threshold), 43, 1, 2, 94, "", 0 },

  { 48, "vehicle_plant/Vehicle_Plant/Generator/Gain/Gain", offsetof
    (Parameters_Vehicle_Plant, Gain_Gain_n), 43, 1, 2, 96, "", 0 },

  { 49, "vehicle_plant/Vehicle_Plant/Battery/Switch3/Threshold", offsetof
    (Parameters_Vehicle_Plant, Switch3_Threshold), 43, 1, 2, 98, "", 0 },

  { 50, "vehicle_plant/Vehicle_Plant/Electric_Motor/Memory1/X0", offsetof
    (Parameters_Vehicle_Plant, Memory1_X0_h), 43, 1, 2, 100, "", 0 },

  { 51, "vehicle_plant/Vehicle_Plant/Electric_Motor/Constant1/Value", offsetof
    (Parameters_Vehicle_Plant, Constant1_Value_b), 43, 1, 2, 102, "", 0 },

  { 52, "vehicle_plant/Vehicle_Plant/Electric_Motor/Switch1/Threshold", offsetof
    (Parameters_Vehicle_Plant, Switch1_Threshold_e), 43, 1, 2, 104, "", 0 },

  { 53, "vehicle_plant/Vehicle_Plant/Electric_Motor/Motion Sensor/Gain V/Gain",
    offsetof(Parameters_Vehicle_Plant, GainV_Gain_h), 43, 1, 2, 106, "", 0 },

  { 54, "vehicle_plant/Vehicle_Plant/Electric_Motor/Gain1/Gain", offsetof
    (Parameters_Vehicle_Plant, Gain1_Gain_k), 43, 1, 2, 108, "", 0 },

  { 55, "vehicle_plant/Vehicle_Plant/Electric_Motor/Memory/X0", offsetof
    (Parameters_Vehicle_Plant, Memory_X0_o), 43, 1, 2, 110, "", 0 },

  { 56, "vehicle_plant/Vehicle_Plant/Electric_Motor/Lookup Table (2-D)/RowIndex",
    offsetof(Parameters_Vehicle_Plant, LookupTable2D_RowIdx_n), 44, 21, 2, 112,
    "", 0 },

  { 57,
    "vehicle_plant/Vehicle_Plant/Electric_Motor/Lookup Table (2-D)/ColumnIndex",
    offsetof(Parameters_Vehicle_Plant, LookupTable2D_ColIdx_l), 45, 10, 2, 114,
    "", 0 },

  { 58, "vehicle_plant/Vehicle_Plant/Electric_Motor/Lookup Table (2-D)/Table",
    offsetof(Parameters_Vehicle_Plant, LookupTable2D_Table_c), 46, 210, 2, 116,
    "", 0 },

  { 59, "vehicle_plant/Vehicle_Plant/Electric_Motor/Lookup Table/InputValues",
    offsetof(Parameters_Vehicle_Plant, LookupTable_XData_o), 47, 16, 2, 118, "",
    0 },

  { 60, "vehicle_plant/Vehicle_Plant/Electric_Motor/Lookup Table/Table",
    offsetof(Parameters_Vehicle_Plant, LookupTable_YData_p), 47, 16, 2, 120, "",
    0 },

  { 61, "vehicle_plant/Vehicle_Plant/Electric_Motor/Constant/Value", offsetof
    (Parameters_Vehicle_Plant, Constant_Value_n), 43, 1, 2, 122, "", 0 },

  { 62, "vehicle_plant/Vehicle_Plant/Electric_Motor/Switch/Threshold", offsetof
    (Parameters_Vehicle_Plant, Switch_Threshold_i), 43, 1, 2, 124, "", 0 },

  { 63, "vehicle_plant/Vehicle_Plant/Electric_Motor/Gain/Gain", offsetof
    (Parameters_Vehicle_Plant, Gain_Gain_p), 43, 1, 2, 126, "", 0 },

  { 64, "vehicle_plant/NI_Display_and_Logging/Battery_Current/Gain", offsetof
    (Parameters_Vehicle_Plant, Battery_Current_Gain), 43, 1, 2, 128, "", 0 },

  { 65, "vehicle_plant/NI_Display_and_Logging/Battery_SOC/Gain", offsetof
    (Parameters_Vehicle_Plant, Battery_SOC_Gain), 43, 1, 2, 130, "", 0 },

  { 66, "vehicle_plant/NI_Display_and_Logging/Battery_Voltage/Gain", offsetof
    (Parameters_Vehicle_Plant, Battery_Voltage_Gain), 43, 1, 2, 132, "", 0 },

  { 67, "vehicle_plant/NI_Display_and_Logging/Engine_rpm/Gain", offsetof
    (Parameters_Vehicle_Plant, Engine_rpm_Gain), 43, 1, 2, 134, "", 0 },

  { 68, "vehicle_plant/NI_Display_and_Logging/Generator_Current/Gain", offsetof
    (Parameters_Vehicle_Plant, Generator_Current_Gain), 43, 1, 2, 136, "", 0 },

  { 69, "vehicle_plant/NI_Display_and_Logging/Motor_Current/Gain", offsetof
    (Parameters_Vehicle_Plant, Motor_Current_Gain), 43, 1, 2, 138, "", 0 },

  { 70, "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Gain3/Gain", offsetof
    (Parameters_Vehicle_Plant, Gain3_Gain), 43, 1, 2, 140, "", 0 },

  { 71, "vehicle_plant/NI_Display_and_Logging/Vehicle_Speed_mph/Gain", offsetof
    (Parameters_Vehicle_Plant, Vehicle_Speed_mph_Gain), 43, 1, 2, 142, "", 0 },

  { 72, "vehicle_plant/NI_Display_and_Logging/Constant/Value", offsetof
    (Parameters_Vehicle_Plant, Constant_Value_k), 43, 1, 2, 144, "", 0 },

  { 73, "vehicle_plant/NI_Display_and_Logging/Discrete-Time Integrator/gainval",
    offsetof(Parameters_Vehicle_Plant, DiscreteTimeIntegrator_gainval), 0, 1, 2,
    146, "", 0 },

  { 74,
    "vehicle_plant/NI_Display_and_Logging/Discrete-Time Integrator/InitialCondition",
    offsetof(Parameters_Vehicle_Plant, DiscreteTimeIntegrator_IC), 43, 1, 2, 148,
    "", 0 },

  { 75, "vehicle_plant/NI_Display_and_Logging/Time/Gain", offsetof
    (Parameters_Vehicle_Plant, Time_Gain), 43, 1, 2, 150, "", 0 },

  { 76, "vehicle_plant/Vehicle_Plant/Battery/Constant4/Value", offsetof
    (Parameters_Vehicle_Plant, Constant4_Value), 43, 1, 2, 152, "", 0 },

  { 77, "vehicle_plant/Vehicle_Plant/Battery/Rate Limiter/RisingSlewLimit",
    offsetof(Parameters_Vehicle_Plant, RateLimiter_RisingLim), 43, 1, 2, 154, "",
    0 },

  { 78, "vehicle_plant/Vehicle_Plant/Battery/Rate Limiter/FallingSlewLimit",
    offsetof(Parameters_Vehicle_Plant, RateLimiter_FallingLim), 43, 1, 2, 156,
    "", 0 },

  { 79, "vehicle_plant/Vehicle_Plant/Engine/Throttle1/Value", offsetof
    (Parameters_Vehicle_Plant, Throttle1_Value), 43, 1, 2, 158, "", 0 },

  { 80, "vehicle_plant/Vehicle_Plant/Engine/Switch/Threshold", offsetof
    (Parameters_Vehicle_Plant, Switch_Threshold_n), 43, 1, 2, 160, "", 0 },

  { 81, "vehicle_plant/Vehicle_Plant/Engine/Integrator/InitialCondition",
    offsetof(Parameters_Vehicle_Plant, Integrator_IC_l), 43, 1, 2, 162, "", 0 },

  { 82, "vehicle_plant/Vehicle_Plant/Engine/Throttle2/Value", offsetof
    (Parameters_Vehicle_Plant, Throttle2_Value), 43, 1, 2, 164, "", 0 },

  { 83, "vehicle_plant/Vehicle_Plant/Engine/Switch1/Threshold", offsetof
    (Parameters_Vehicle_Plant, Switch1_Threshold_n), 43, 1, 2, 166, "", 0 },

  { 84, "vehicle_plant/Vehicle_Plant/Engine/Throttle3/Value", offsetof
    (Parameters_Vehicle_Plant, Throttle3_Value), 43, 1, 2, 168, "", 0 },

  { 85, "vehicle_plant/Vehicle_Plant/Engine/Switch2/Threshold", offsetof
    (Parameters_Vehicle_Plant, Switch2_Threshold), 43, 1, 2, 170, "", 0 },

  { 86, "vehicle_plant/Vehicle_Plant/Engine/Transfer Fcn/A", offsetof
    (Parameters_Vehicle_Plant, TransferFcn_A), 43, 1, 2, 172, "", 0 },

  { 87, "vehicle_plant/Vehicle_Plant/Engine/Transfer Fcn/C", offsetof
    (Parameters_Vehicle_Plant, TransferFcn_C), 43, 1, 2, 174, "", 0 },

  { 88,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes/Saturation 0 to 1/UpperLimit",
    offsetof(Parameters_Vehicle_Plant, Saturation0to1_UpperSat), 43, 1, 2, 176,
    "", 0 },

  { 89,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes/Saturation 0 to 1/LowerLimit",
    offsetof(Parameters_Vehicle_Plant, Saturation0to1_LowerSat), 43, 1, 2, 178,
    "", 0 },

  { 90,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes/Brake Slew Rate (.25 s)/RisingSlewLimit",
    offsetof(Parameters_Vehicle_Plant, BrakeSlewRate25s_RisingLim), 43, 1, 2,
    180, "", 0 },

  { 91,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes/Brake Slew Rate (.25 s)/FallingSlewLimit",
    offsetof(Parameters_Vehicle_Plant, BrakeSlewRate25s_FallingLim), 43, 1, 2,
    182, "", 0 },

  { 92,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes/Brake Max Torque/Gain",
    offsetof(Parameters_Vehicle_Plant, BrakeMaxTorque_Gain), 43, 1, 2, 184, "",
    0 },

  { 93,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes/m//s to mph/Gain",
    offsetof(Parameters_Vehicle_Plant, mstomph_Gain), 43, 1, 2, 186, "", 0 },

  { 94,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes/Brake Torque Map/InputValues",
    offsetof(Parameters_Vehicle_Plant, BrakeTorqueMap_XData), 50, 3, 2, 188, "",
    0 },

  { 95,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes/Brake Torque Map/Table",
    offsetof(Parameters_Vehicle_Plant, BrakeTorqueMap_YData), 50, 3, 2, 190, "",
    0 },

  { 96,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes/Motion Sensor/Gain V/Gain",
    offsetof(Parameters_Vehicle_Plant, GainV_Gain_p), 43, 1, 2, 192, "", 0 },

  { 97,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes/SGN/InputValues",
    offsetof(Parameters_Vehicle_Plant, SGN_XData), 51, 5, 2, 194, "", 0 },

  { 98,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes/SGN/Table",
    offsetof(Parameters_Vehicle_Plant, SGN_YData), 51, 5, 2, 196, "", 0 },

  { 99,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes/Rate Limiter 10, -10/RisingSlewLimit",
    offsetof(Parameters_Vehicle_Plant, RateLimiter1010_RisingLim), 43, 1, 2, 198,
    "", 0 },

  { 100,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes/Rate Limiter 10, -10/FallingSlewLimit",
    offsetof(Parameters_Vehicle_Plant, RateLimiter1010_FallingLim), 43, 1, 2,
    200, "", 0 },

  { 101,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes1/Saturation 0 to 1/UpperLimit",
    offsetof(Parameters_Vehicle_Plant, Saturation0to1_UpperSat_c), 43, 1, 2, 202,
    "", 0 },

  { 102,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes1/Saturation 0 to 1/LowerLimit",
    offsetof(Parameters_Vehicle_Plant, Saturation0to1_LowerSat_d), 43, 1, 2, 204,
    "", 0 },

  { 103,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes1/Brake Slew Rate (.25 s)/RisingSlewLimit",
    offsetof(Parameters_Vehicle_Plant, BrakeSlewRate25s_RisingLim_l), 43, 1, 2,
    206, "", 0 },

  { 104,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes1/Brake Slew Rate (.25 s)/FallingSlewLimit",
    offsetof(Parameters_Vehicle_Plant, BrakeSlewRate25s_FallingLim_b), 43, 1, 2,
    208, "", 0 },

  { 105,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes1/Brake Max Torque/Gain",
    offsetof(Parameters_Vehicle_Plant, BrakeMaxTorque_Gain_n), 43, 1, 2, 210, "",
    0 },

  { 106,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes1/m//s to mph/Gain",
    offsetof(Parameters_Vehicle_Plant, mstomph_Gain_i), 43, 1, 2, 212, "", 0 },

  { 107,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes1/Brake Torque Map/InputValues",
    offsetof(Parameters_Vehicle_Plant, BrakeTorqueMap_XData_j), 50, 3, 2, 214,
    "", 0 },

  { 108,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes1/Brake Torque Map/Table",
    offsetof(Parameters_Vehicle_Plant, BrakeTorqueMap_YData_o), 50, 3, 2, 216,
    "", 0 },

  { 109,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes1/Motion Sensor/Gain V/Gain",
    offsetof(Parameters_Vehicle_Plant, GainV_Gain_h0), 43, 1, 2, 218, "", 0 },

  { 110,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes1/SGN/InputValues",
    offsetof(Parameters_Vehicle_Plant, SGN_XData_h), 51, 5, 2, 220, "", 0 },

  { 111,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes1/SGN/Table",
    offsetof(Parameters_Vehicle_Plant, SGN_YData_i), 51, 5, 2, 222, "", 0 },

  { 112,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes1/Rate Limiter 10, -10/RisingSlewLimit",
    offsetof(Parameters_Vehicle_Plant, RateLimiter1010_RisingLim_j), 43, 1, 2,
    224, "", 0 },

  { 113,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes1/Rate Limiter 10, -10/FallingSlewLimit",
    offsetof(Parameters_Vehicle_Plant, RateLimiter1010_FallingLim_a), 43, 1, 2,
    226, "", 0 },

  { 114, "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Constant/Value",
    offsetof(Parameters_Vehicle_Plant, Constant_Value_j), 43, 1, 2, 228, "", 0 },

  { 115, "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Constant1/Value",
    offsetof(Parameters_Vehicle_Plant, Constant1_Value_m), 43, 1, 2, 230, "", 0
  },

  { 116,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Integrator/InitialCondition",
    offsetof(Parameters_Vehicle_Plant, Integrator_IC_g), 43, 1, 2, 232, "", 0 },

  { 117,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Longitudinal Vehicle Dynamics/Gain3/Gain",
    offsetof(Parameters_Vehicle_Plant, Gain3_Gain_a), 43, 1, 2, 234, "", 0 },

  { 118,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Longitudinal Vehicle Dynamics/rho/Gain",
    offsetof(Parameters_Vehicle_Plant, rho_Gain), 43, 1, 2, 236, "", 0 },

  { 119,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Longitudinal Vehicle Dynamics/Drag coefficient/Gain",
    offsetof(Parameters_Vehicle_Plant, Dragcoefficient_Gain), 43, 1, 2, 238, "",
    0 },

  { 120,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Longitudinal Vehicle Dynamics/Frontal area/Gain",
    offsetof(Parameters_Vehicle_Plant, Frontalarea_Gain), 43, 1, 2, 240, "", 0 },

  { 121,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/RHIT Tire/Torque Sensor/Gain/Gain",
    offsetof(Parameters_Vehicle_Plant, Gain_Gain_j), 43, 1, 2, 242, "", 0 },

  { 122, "vehicle_plant/Vehicle_Plant/Rear Diff and Body/RHIT Tire/Gain2/Gain",
    offsetof(Parameters_Vehicle_Plant, Gain2_Gain), 43, 1, 2, 244, "", 0 },

  { 123,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/RHIT Tire1/Torque Sensor/Gain/Gain",
    offsetof(Parameters_Vehicle_Plant, Gain_Gain_g), 43, 1, 2, 246, "", 0 },

  { 124, "vehicle_plant/Vehicle_Plant/Rear Diff and Body/RHIT Tire1/Gain2/Gain",
    offsetof(Parameters_Vehicle_Plant, Gain2_Gain_c), 43, 1, 2, 248, "", 0 },

  { 125,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Longitudinal Vehicle Dynamics/Incline gravity/Gain",
    offsetof(Parameters_Vehicle_Plant, Inclinegravity_Gain), 43, 1, 2, 250, "",
    0 },

  { 126,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Longitudinal Vehicle Dynamics/Gain1/Gain",
    offsetof(Parameters_Vehicle_Plant, Gain1_Gain_c), 43, 1, 2, 252, "", 0 },

  { 127,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Longitudinal Vehicle Dynamics/Transfer Fcn1/A",
    offsetof(Parameters_Vehicle_Plant, TransferFcn1_A), 52, 2, 2, 254, "", 0 },

  { 128,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Longitudinal Vehicle Dynamics/Transfer Fcn1/C",
    offsetof(Parameters_Vehicle_Plant, TransferFcn1_C), 53, 2, 2, 256, "", 0 },

  { 129, "vehicle_plant/Vehicle_Plant/Battery/Constant8/Value", offsetof
    (Parameters_Vehicle_Plant, Constant8_Value), 43, 1, 2, 258, "", 0 },

  { 130, "vehicle_plant/Vehicle_Plant/Battery/Constant7/Value", offsetof
    (Parameters_Vehicle_Plant, Constant7_Value), 43, 1, 2, 260, "", 0 },

  { 131, "vehicle_plant/Vehicle_Plant/Battery/Constant6/Value", offsetof
    (Parameters_Vehicle_Plant, Constant6_Value), 43, 1, 2, 262, "", 0 },

  { 132, "vehicle_plant/Vehicle_Plant/Battery/Switch2/Threshold", offsetof
    (Parameters_Vehicle_Plant, Switch2_Threshold_b), 43, 1, 2, 264, "", 0 },

  { 133, "vehicle_plant/Vehicle_Plant/Battery/Discharge  Resistance/RowIndex",
    offsetof(Parameters_Vehicle_Plant, DischargeResistance_RowIdx), 54, 9, 2,
    266, "", 0 },

  { 134, "vehicle_plant/Vehicle_Plant/Battery/Discharge  Resistance/ColumnIndex",
    offsetof(Parameters_Vehicle_Plant, DischargeResistance_ColIdx), 51, 5, 2,
    268, "", 0 },

  { 135, "vehicle_plant/Vehicle_Plant/Battery/Discharge  Resistance/Table",
    offsetof(Parameters_Vehicle_Plant, DischargeResistance_Table), 55, 45, 2,
    270, "", 0 },

  { 136, "vehicle_plant/Vehicle_Plant/Battery/Charge  Resistance/RowIndex",
    offsetof(Parameters_Vehicle_Plant, ChargeResistance_RowIdx), 54, 9, 2, 272,
    "", 0 },

  { 137, "vehicle_plant/Vehicle_Plant/Battery/Charge  Resistance/ColumnIndex",
    offsetof(Parameters_Vehicle_Plant, ChargeResistance_ColIdx), 51, 5, 2, 274,
    "", 0 },

  { 138, "vehicle_plant/Vehicle_Plant/Battery/Charge  Resistance/Table",
    offsetof(Parameters_Vehicle_Plant, ChargeResistance_Table), 55, 45, 2, 276,
    "", 0 },

  { 139, "vehicle_plant/Vehicle_Plant/Battery/Switch/Threshold", offsetof
    (Parameters_Vehicle_Plant, Switch_Threshold_f), 43, 1, 2, 278, "", 0 },

  { 140, "vehicle_plant/Vehicle_Plant/Battery/Battery OCV/RowIndex", offsetof
    (Parameters_Vehicle_Plant, BatteryOCV_RowIdx), 54, 9, 2, 280, "", 0 },

  { 141, "vehicle_plant/Vehicle_Plant/Battery/Battery OCV/ColumnIndex", offsetof
    (Parameters_Vehicle_Plant, BatteryOCV_ColIdx), 51, 5, 2, 282, "", 0 },

  { 142, "vehicle_plant/Vehicle_Plant/Battery/Battery OCV/Table", offsetof
    (Parameters_Vehicle_Plant, BatteryOCV_Table), 55, 45, 2, 284, "", 0 },

  { 143, "vehicle_plant/Vehicle_Plant/Battery/Saturation/UpperLimit", offsetof
    (Parameters_Vehicle_Plant, Saturation_UpperSat), 43, 1, 2, 286, "", 0 },

  { 144, "vehicle_plant/Vehicle_Plant/Battery/Saturation/LowerLimit", offsetof
    (Parameters_Vehicle_Plant, Saturation_LowerSat), 43, 1, 2, 288, "", 0 },

  { 145, "vehicle_plant/Vehicle_Plant/Electric_Motor/Constant2/Value", offsetof
    (Parameters_Vehicle_Plant, Constant2_Value_o), 43, 1, 2, 290, "", 0 },

  { 146, "vehicle_plant/Vehicle_Plant/Engine/Fuel Consumption Data/RowIndex",
    offsetof(Parameters_Vehicle_Plant, FuelConsumptionData_RowIdx), 54, 9, 2,
    292, "", 0 },

  { 147, "vehicle_plant/Vehicle_Plant/Engine/Fuel Consumption Data/ColumnIndex",
    offsetof(Parameters_Vehicle_Plant, FuelConsumptionData_ColIdx), 56, 6, 2,
    294, "", 0 },

  { 148, "vehicle_plant/Vehicle_Plant/Engine/Fuel Consumption Data/Table",
    offsetof(Parameters_Vehicle_Plant, FuelConsumptionData_Table), 57, 54, 2,
    296, "", 0 },

  { 149, "vehicle_plant/Vehicle_Plant/Engine/Engine Torque Data/RowIndex",
    offsetof(Parameters_Vehicle_Plant, EngineTorqueData_RowIdx), 54, 9, 2, 298,
    "", 0 },

  { 150, "vehicle_plant/Vehicle_Plant/Engine/Engine Torque Data/ColumnIndex",
    offsetof(Parameters_Vehicle_Plant, EngineTorqueData_ColIdx), 56, 6, 2, 300,
    "", 0 },

  { 151, "vehicle_plant/Vehicle_Plant/Engine/Engine Torque Data/Table", offsetof
    (Parameters_Vehicle_Plant, EngineTorqueData_Table), 57, 54, 2, 302, "", 0 },

  { 152, "vehicle_plant/Vehicle_Plant/Engine/Saturation/UpperLimit", offsetof
    (Parameters_Vehicle_Plant, Saturation_UpperSat_k), 43, 1, 2, 304, "", 0 },

  { 153, "vehicle_plant/Vehicle_Plant/Engine/Saturation/LowerLimit", offsetof
    (Parameters_Vehicle_Plant, Saturation_LowerSat_b), 43, 1, 2, 306, "", 0 },

  { 154, "vehicle_plant/Vehicle_Plant/Generator/Constant2/Value", offsetof
    (Parameters_Vehicle_Plant, Constant2_Value_f), 43, 1, 2, 308, "", 0 },

  { 155, "vehicle_plant/Vehicle_Plant/Battery/Manual Switch/Constant/Value",
    offsetof(Parameters_Vehicle_Plant, Constant_Value_d), 58, 1, 2, 310, "", 0 },

  { 156,
    "vehicle_plant/Vehicle_Plant/Battery/Manual Switch/SwitchControl/Threshold",
    offsetof(Parameters_Vehicle_Plant, SwitchControl_Threshold), 58, 1, 2, 312,
    "", 0 },

  { 157,
    "vehicle_plant/Vehicle_Plant/Electric_Motor/Manual Switch/Constant/Value",
    offsetof(Parameters_Vehicle_Plant, Constant_Value_p), 58, 1, 2, 314, "", 0 },

  { 158,
    "vehicle_plant/Vehicle_Plant/Electric_Motor/Manual Switch/SwitchControl/Threshold",
    offsetof(Parameters_Vehicle_Plant, SwitchControl_Threshold_b), 58, 1, 2, 316,
    "", 0 },

  { 159, "vehicle_plant/Vehicle_Plant/Generator/Manual Switch/Constant/Value",
    offsetof(Parameters_Vehicle_Plant, Constant_Value_e), 58, 1, 2, 318, "", 0 },

  { 160,
    "vehicle_plant/Vehicle_Plant/Generator/Manual Switch/SwitchControl/Threshold",
    offsetof(Parameters_Vehicle_Plant, SwitchControl_Threshold_h), 58, 1, 2, 320,
    "", 0 },
};

static int NI_ParamListSize = 161;
static int NI_ParamDimList[] = {
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/RHIT Tire1/Motion Actuator1/integrator/InitialCondition */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Longitudinal Vehicle Dynamics/Integrator/InitialCondition */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/RHIT Tire1/Gain1/Gain */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/RHIT Tire1/Constant2/Value */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/RHIT Tire/Motion Actuator1/integrator/InitialCondition */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/RHIT Tire/Gain1/Gain */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/RHIT Tire/Constant2/Value */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Passenger Half-shaft/Inertia/Value */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Passenger Half-shaft/InitialCondition/Value */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Differential 3.73:1 ratio/Simple Gear3/GearRatio/Value */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Differential 3.73:1 ratio/Planet-Planet/PlanetPlanetRatio/Value */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Differential 3.73:1 ratio/Planet-Planet1/PlanetPlanetRatio/Value */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Differential 3.73:1 ratio/Simple Gear/GearRatio/Value */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Differential 3.73:1 ratio/Simple Gear2/GearRatio/Value */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Driver Half-shaft/Inertia/Value */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Driver Half-shaft/InitialCondition/Value */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Differential 3.73:1 ratio/Simple Gear1/GearRatio/Value */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Engine/Engine/Inertia/Value */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Engine/Engine/InitialCondition/Value */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Generator/Inertia/Inertia/Value */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Generator/Inertia/InitialCondition/Value */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Electric_Motor/Inertia/Inertia/Value */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Electric_Motor/Inertia/InitialCondition/Value */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Engine/Motion Sensor/Gain V/Gain */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Engine/rad to rpm/Gain */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Battery/Integrator/InitialCondition */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Battery/Gain/Gain */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Battery/Constant2/Value */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Battery/Constant3/Value */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Generator/Motion Sensor/Gain V/Gain */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Generator/Gain1/Gain */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Generator/Memory/X0 */
  21, 1,                               /* vehicle_plant/Vehicle_Plant/Generator/Lookup Table (2-D)/RowIndex */
  1, 10,                               /* vehicle_plant/Vehicle_Plant/Generator/Lookup Table (2-D)/ColumnIndex */
  21, 10,                              /* vehicle_plant/Vehicle_Plant/Generator/Lookup Table (2-D)/Table */
  1, 16,                               /* vehicle_plant/Vehicle_Plant/Generator/Lookup Table/InputValues */
  1, 16,                               /* vehicle_plant/Vehicle_Plant/Generator/Lookup Table/Table */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Generator/Memory1/X0 */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Battery/Battery Temperature1/Value */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Battery/Battery Temperature/Value */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Battery/Memory/X0 */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Battery/Memory1/X0 */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Battery/Constant1/Value */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Battery/Switch1/Threshold */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Generator/Constant1/Value */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Generator/Switch1/Threshold */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Generator/Constant/Value */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Generator/Switch/Threshold */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Generator/Gain/Gain */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Battery/Switch3/Threshold */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Electric_Motor/Memory1/X0 */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Electric_Motor/Constant1/Value */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Electric_Motor/Switch1/Threshold */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Electric_Motor/Motion Sensor/Gain V/Gain */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Electric_Motor/Gain1/Gain */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Electric_Motor/Memory/X0 */
  21, 1,                               /* vehicle_plant/Vehicle_Plant/Electric_Motor/Lookup Table (2-D)/RowIndex */
  1, 10,                               /* vehicle_plant/Vehicle_Plant/Electric_Motor/Lookup Table (2-D)/ColumnIndex */
  21, 10,                              /* vehicle_plant/Vehicle_Plant/Electric_Motor/Lookup Table (2-D)/Table */
  1, 16,                               /* vehicle_plant/Vehicle_Plant/Electric_Motor/Lookup Table/InputValues */
  1, 16,                               /* vehicle_plant/Vehicle_Plant/Electric_Motor/Lookup Table/Table */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Electric_Motor/Constant/Value */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Electric_Motor/Switch/Threshold */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Electric_Motor/Gain/Gain */
  1, 1,                                /* vehicle_plant/NI_Display_and_Logging/Battery_Current/Gain */
  1, 1,                                /* vehicle_plant/NI_Display_and_Logging/Battery_SOC/Gain */
  1, 1,                                /* vehicle_plant/NI_Display_and_Logging/Battery_Voltage/Gain */
  1, 1,                                /* vehicle_plant/NI_Display_and_Logging/Engine_rpm/Gain */
  1, 1,                                /* vehicle_plant/NI_Display_and_Logging/Generator_Current/Gain */
  1, 1,                                /* vehicle_plant/NI_Display_and_Logging/Motor_Current/Gain */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Gain3/Gain */
  1, 1,                                /* vehicle_plant/NI_Display_and_Logging/Vehicle_Speed_mph/Gain */
  1, 1,                                /* vehicle_plant/NI_Display_and_Logging/Constant/Value */
  1, 1,                                /* vehicle_plant/NI_Display_and_Logging/Discrete-Time Integrator/gainval */
  1, 1,                                /* vehicle_plant/NI_Display_and_Logging/Discrete-Time Integrator/InitialCondition */
  1, 1,                                /* vehicle_plant/NI_Display_and_Logging/Time/Gain */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Battery/Constant4/Value */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Battery/Rate Limiter/RisingSlewLimit */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Battery/Rate Limiter/FallingSlewLimit */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Engine/Throttle1/Value */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Engine/Switch/Threshold */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Engine/Integrator/InitialCondition */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Engine/Throttle2/Value */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Engine/Switch1/Threshold */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Engine/Throttle3/Value */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Engine/Switch2/Threshold */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Engine/Transfer Fcn/A */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Engine/Transfer Fcn/C */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes/Saturation 0 to 1/UpperLimit */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes/Saturation 0 to 1/LowerLimit */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes/Brake Slew Rate (.25 s)/RisingSlewLimit */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes/Brake Slew Rate (.25 s)/FallingSlewLimit */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes/Brake Max Torque/Gain */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes/m//s to mph/Gain */
  1, 3,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes/Brake Torque Map/InputValues */
  1, 3,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes/Brake Torque Map/Table */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes/Motion Sensor/Gain V/Gain */
  1, 5,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes/SGN/InputValues */
  1, 5,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes/SGN/Table */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes/Rate Limiter 10, -10/RisingSlewLimit */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes/Rate Limiter 10, -10/FallingSlewLimit */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes1/Saturation 0 to 1/UpperLimit */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes1/Saturation 0 to 1/LowerLimit */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes1/Brake Slew Rate (.25 s)/RisingSlewLimit */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes1/Brake Slew Rate (.25 s)/FallingSlewLimit */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes1/Brake Max Torque/Gain */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes1/m//s to mph/Gain */
  1, 3,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes1/Brake Torque Map/InputValues */
  1, 3,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes1/Brake Torque Map/Table */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes1/Motion Sensor/Gain V/Gain */
  1, 5,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes1/SGN/InputValues */
  1, 5,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes1/SGN/Table */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes1/Rate Limiter 10, -10/RisingSlewLimit */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes1/Rate Limiter 10, -10/FallingSlewLimit */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Constant/Value */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Constant1/Value */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Integrator/InitialCondition */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Longitudinal Vehicle Dynamics/Gain3/Gain */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Longitudinal Vehicle Dynamics/rho/Gain */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Longitudinal Vehicle Dynamics/Drag coefficient/Gain */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Longitudinal Vehicle Dynamics/Frontal area/Gain */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/RHIT Tire/Torque Sensor/Gain/Gain */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/RHIT Tire/Gain2/Gain */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/RHIT Tire1/Torque Sensor/Gain/Gain */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/RHIT Tire1/Gain2/Gain */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Longitudinal Vehicle Dynamics/Incline gravity/Gain */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Longitudinal Vehicle Dynamics/Gain1/Gain */
  2, 1,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Longitudinal Vehicle Dynamics/Transfer Fcn1/A */
  1, 2,                                /* vehicle_plant/Vehicle_Plant/Rear Diff and Body/Longitudinal Vehicle Dynamics/Transfer Fcn1/C */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Battery/Constant8/Value */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Battery/Constant7/Value */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Battery/Constant6/Value */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Battery/Switch2/Threshold */
  9, 1,                                /* vehicle_plant/Vehicle_Plant/Battery/Discharge  Resistance/RowIndex */
  1, 5,                                /* vehicle_plant/Vehicle_Plant/Battery/Discharge  Resistance/ColumnIndex */
  9, 5,                                /* vehicle_plant/Vehicle_Plant/Battery/Discharge  Resistance/Table */
  9, 1,                                /* vehicle_plant/Vehicle_Plant/Battery/Charge  Resistance/RowIndex */
  1, 5,                                /* vehicle_plant/Vehicle_Plant/Battery/Charge  Resistance/ColumnIndex */
  9, 5,                                /* vehicle_plant/Vehicle_Plant/Battery/Charge  Resistance/Table */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Battery/Switch/Threshold */
  9, 1,                                /* vehicle_plant/Vehicle_Plant/Battery/Battery OCV/RowIndex */
  1, 5,                                /* vehicle_plant/Vehicle_Plant/Battery/Battery OCV/ColumnIndex */
  9, 5,                                /* vehicle_plant/Vehicle_Plant/Battery/Battery OCV/Table */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Battery/Saturation/UpperLimit */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Battery/Saturation/LowerLimit */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Electric_Motor/Constant2/Value */
  9, 1,                                /* vehicle_plant/Vehicle_Plant/Engine/Fuel Consumption Data/RowIndex */
  1, 6,                                /* vehicle_plant/Vehicle_Plant/Engine/Fuel Consumption Data/ColumnIndex */
  9, 6,                                /* vehicle_plant/Vehicle_Plant/Engine/Fuel Consumption Data/Table */
  9, 1,                                /* vehicle_plant/Vehicle_Plant/Engine/Engine Torque Data/RowIndex */
  1, 6,                                /* vehicle_plant/Vehicle_Plant/Engine/Engine Torque Data/ColumnIndex */
  9, 6,                                /* vehicle_plant/Vehicle_Plant/Engine/Engine Torque Data/Table */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Engine/Saturation/UpperLimit */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Engine/Saturation/LowerLimit */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Generator/Constant2/Value */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Battery/Manual Switch/Constant/Value */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Battery/Manual Switch/SwitchControl/Threshold */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Electric_Motor/Manual Switch/Constant/Value */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Electric_Motor/Manual Switch/SwitchControl/Threshold */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Generator/Manual Switch/Constant/Value */
  1, 1,                                /* vehicle_plant/Vehicle_Plant/Generator/Manual Switch/SwitchControl/Threshold */
};

static int NI_VariablesListSize = 0;
static char *NI_VariablesList[] = {
  ""
};

static int NI_SigListSize = 62;
static NI_Signal NI_SigList[] = {
  { 0,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Longitudinal Vehicle Dynamics/Integrator",
    0, "", offsetof(BlockIO_Vehicle_Plant, Integrator), BLOCKIO_SIG, 0, 1, 2, 0,
    0 },

  { 1, "vehicle_plant/Vehicle_Plant/Rear Diff and Body/RHIT Tire1/Gain1", 0, "",
    offsetof(BlockIO_Vehicle_Plant, Gain1), BLOCKIO_SIG, 0, 1, 2, 2, 0 },

  { 2, "vehicle_plant/Vehicle_Plant/Rear Diff and Body/RHIT Tire/Gain1", 0, "",
    offsetof(BlockIO_Vehicle_Plant, Gain1_b), BLOCKIO_SIG, 0, 1, 2, 4, 0 },

  { 3,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Driveline Environment/Subsystem/Parameter Block",
    0, "", offsetof(BlockIO_Vehicle_Plant, ParameterBlock), BLOCKIO_SIG, 0, 1, 2,
    6, 0 },

  { 4,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Driveline Environment/Subsystem/Kinematic Block",
    0, "", offsetof(BlockIO_Vehicle_Plant, KinematicBlock_o1), BLOCKIO_SIG, 20,
    6, 2, 8, 0 },

  { 5,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Driveline Environment/Subsystem/Kinematic Block",
    1, "", offsetof(BlockIO_Vehicle_Plant, KinematicBlock_o2), BLOCKIO_SIG, 22,
    3, 2, 10, 0 },

  { 6,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Driveline Environment/Subsystem/Kinematic Block",
    2, "", offsetof(BlockIO_Vehicle_Plant, KinematicBlock_o3), BLOCKIO_SIG, 0, 1,
    2, 12, 0 },

  { 7,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Driveline Environment/Subsystem/Kinematic Block",
    3, "", offsetof(BlockIO_Vehicle_Plant, KinematicBlock_o4), BLOCKIO_SIG, 21,
    5, 2, 14, 0 },

  { 8, "vehicle_plant/Vehicle_Plant/Generator/Memory", 0, "", offsetof
    (BlockIO_Vehicle_Plant, Memory), BLOCKIO_SIG, 0, 1, 2, 16, 0 },

  { 9, "vehicle_plant/Vehicle_Plant/Generator/Memory1", 0, "", offsetof
    (BlockIO_Vehicle_Plant, Memory1), BLOCKIO_SIG, 0, 1, 2, 18, 0 },

  { 10, "vehicle_plant/Vehicle_Plant/Battery/Memory", 0, "", offsetof
    (BlockIO_Vehicle_Plant, Memory_f), BLOCKIO_SIG, 0, 1, 2, 20, 0 },

  { 11, "vehicle_plant/Vehicle_Plant/Battery/Memory1", 0, "", offsetof
    (BlockIO_Vehicle_Plant, Memory1_g), BLOCKIO_SIG, 0, 1, 2, 22, 0 },

  { 12, "vehicle_plant/Vehicle_Plant/Generator/MinMax", 0, "", offsetof
    (BlockIO_Vehicle_Plant, MinMax), BLOCKIO_SIG, 0, 1, 2, 24, 0 },

  { 13, "vehicle_plant/Vehicle_Plant/Electric_Motor/Memory1", 0, "", offsetof
    (BlockIO_Vehicle_Plant, Memory1_j), BLOCKIO_SIG, 0, 1, 2, 26, 0 },

  { 14, "vehicle_plant/Vehicle_Plant/Electric_Motor/Memory", 0, "", offsetof
    (BlockIO_Vehicle_Plant, Memory_k), BLOCKIO_SIG, 0, 1, 2, 28, 0 },

  { 15, "vehicle_plant/Vehicle_Plant/Electric_Motor/MinMax", 0, "", offsetof
    (BlockIO_Vehicle_Plant, MinMax_c), BLOCKIO_SIG, 0, 1, 2, 30, 0 },

  { 16, "vehicle_plant/NI_Display_and_Logging/Battery_Current", 0, "", offsetof
    (BlockIO_Vehicle_Plant, Battery_Current), BLOCKIO_SIG, 0, 1, 2, 32, 0 },

  { 17, "vehicle_plant/NI_Display_and_Logging/Battery_SOC", 0, "", offsetof
    (BlockIO_Vehicle_Plant, Battery_SOC), BLOCKIO_SIG, 0, 1, 2, 34, 0 },

  { 18, "vehicle_plant/NI_Display_and_Logging/Battery_Voltage", 0, "", offsetof
    (BlockIO_Vehicle_Plant, Battery_Voltage), BLOCKIO_SIG, 0, 1, 2, 36, 0 },

  { 19, "vehicle_plant/NI_Display_and_Logging/Engine_rpm", 0, "", offsetof
    (BlockIO_Vehicle_Plant, Engine_rpm), BLOCKIO_SIG, 0, 1, 2, 38, 0 },

  { 20, "vehicle_plant/NI_Display_and_Logging/Generator_Current", 0, "",
    offsetof(BlockIO_Vehicle_Plant, Generator_Current), BLOCKIO_SIG, 0, 1, 2, 40,
    0 },

  { 21, "vehicle_plant/NI_Display_and_Logging/Motor_Current", 0, "", offsetof
    (BlockIO_Vehicle_Plant, Motor_Current), BLOCKIO_SIG, 0, 1, 2, 42, 0 },

  { 22, "vehicle_plant/NI_Display_and_Logging/Vehicle_Speed_mph", 0, "",
    offsetof(BlockIO_Vehicle_Plant, Vehicle_Speed_mph), BLOCKIO_SIG, 0, 1, 2, 44,
    0 },

  { 23, "vehicle_plant/NI_Display_and_Logging/Time", 0, "", offsetof
    (BlockIO_Vehicle_Plant, Time), BLOCKIO_SIG, 0, 1, 2, 46, 0 },

  { 24, "vehicle_plant/Vehicle_Plant/Battery/Rate Limiter", 0, "", offsetof
    (BlockIO_Vehicle_Plant, RateLimiter), BLOCKIO_SIG, 0, 1, 2, 48, 0 },

  { 25, "vehicle_plant/Vehicle_Plant/Battery/Manual Switch/SwitchControl", 0, "",
    offsetof(BlockIO_Vehicle_Plant, SwitchControl), BLOCKIO_SIG, 0, 1, 2, 50, 0
  },

  { 26, "vehicle_plant/Vehicle_Plant/Battery/Sum", 0, "", offsetof
    (BlockIO_Vehicle_Plant, Sum), BLOCKIO_SIG, 0, 1, 2, 52, 0 },

  { 27, "vehicle_plant/Vehicle_Plant/Electric_Motor/Abs2", 0, "", offsetof
    (BlockIO_Vehicle_Plant, Abs2), BLOCKIO_SIG, 0, 1, 2, 54, 0 },

  { 28, "vehicle_plant/Vehicle_Plant/Electric_Motor/Manual Switch/SwitchControl",
    0, "", offsetof(BlockIO_Vehicle_Plant, SwitchControl_j), BLOCKIO_SIG, 0, 1,
    2, 56, 0 },

  { 29, "vehicle_plant/Vehicle_Plant/Engine/Switch1", 0, "", offsetof
    (BlockIO_Vehicle_Plant, Switch1), BLOCKIO_SIG, 0, 1, 2, 58, 0 },

  { 30, "vehicle_plant/Vehicle_Plant/Engine/Switch2", 0, "", offsetof
    (BlockIO_Vehicle_Plant, Switch2), BLOCKIO_SIG, 0, 1, 2, 60, 0 },

  { 31, "vehicle_plant/Vehicle_Plant/Generator/Abs2", 0, "", offsetof
    (BlockIO_Vehicle_Plant, Abs2_a), BLOCKIO_SIG, 0, 1, 2, 62, 0 },

  { 32, "vehicle_plant/Vehicle_Plant/Generator/Manual Switch/SwitchControl", 0,
    "", offsetof(BlockIO_Vehicle_Plant, SwitchControl_n), BLOCKIO_SIG, 0, 1, 2,
    64, 0 },

  { 33,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes/Brake Slew Rate (.25 s)",
    0, "", offsetof(BlockIO_Vehicle_Plant, BrakeSlewRate25s), BLOCKIO_SIG, 0, 1,
    2, 66, 0 },

  { 34, "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes/SGN",
    0, "", offsetof(BlockIO_Vehicle_Plant, SGN), BLOCKIO_SIG, 0, 1, 2, 68, 0 },

  { 35,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes/Rate Limiter 10, -10",
    0, "", offsetof(BlockIO_Vehicle_Plant, RateLimiter1010), BLOCKIO_SIG, 0, 1,
    2, 70, 0 },

  { 36,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes1/Brake Slew Rate (.25 s)",
    0, "", offsetof(BlockIO_Vehicle_Plant, BrakeSlewRate25s_c), BLOCKIO_SIG, 0,
    1, 2, 72, 0 },

  { 37, "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes1/SGN",
    0, "", offsetof(BlockIO_Vehicle_Plant, SGN_g), BLOCKIO_SIG, 0, 1, 2, 74, 0 },

  { 38,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Foundation Brakes1/Rate Limiter 10, -10",
    0, "", offsetof(BlockIO_Vehicle_Plant, RateLimiter1010_o), BLOCKIO_SIG, 0, 1,
    2, 76, 0 },

  { 39,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Driveline Environment/Subsystem/Dynamic Block",
    0, "", offsetof(BlockIO_Vehicle_Plant, DynamicBlock_o1), BLOCKIO_SIG, 0, 1,
    2, 78, 0 },

  { 40,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Driveline Environment/Subsystem/Dynamic Block",
    1, "", offsetof(BlockIO_Vehicle_Plant, DynamicBlock_o2), BLOCKIO_SIG, 23, 7,
    2, 80, 0 },

  { 41,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Longitudinal Vehicle Dynamics/Incline gravity",
    0, "", offsetof(BlockIO_Vehicle_Plant, Inclinegravity), BLOCKIO_SIG, 0, 1, 2,
    82, 0 },

  { 42,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Longitudinal Vehicle Dynamics/Sum",
    0, "", offsetof(BlockIO_Vehicle_Plant, Sum_b), BLOCKIO_SIG, 0, 1, 2, 84, 0 },

  { 43,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Longitudinal Vehicle Dynamics/Gain1",
    0, "", offsetof(BlockIO_Vehicle_Plant, Gain1_e), BLOCKIO_SIG, 0, 1, 2, 86, 0
  },

  { 44,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Driveline Environment/Subsystem/Event Block",
    0, "", offsetof(BlockIO_Vehicle_Plant, EventBlock), BLOCKIO_SIG, 0, 1, 2, 88,
    0 },

  { 45,
    "vehicle_plant/Vehicle_Plant/Rear Diff and Body/Driveline Environment/Subsystem/Modal loop/Event Feedback",
    0, "", offsetof(BlockIO_Vehicle_Plant, EventFeedback), BLOCKIO_SIG, 0, 1, 2,
    90, 0 },

  { 46, "vehicle_plant/NI_Display_and_Logging/Battery_Current", 0, "", 0,
    VIRTUAL_SIG, 0, 1, 2, 92, 0 },

  { 47, "vehicle_plant/NI_Display_and_Logging/Battery_SOC", 0, "", 1,
    VIRTUAL_SIG, 0, 1, 2, 94, 0 },

  { 48, "vehicle_plant/NI_Display_and_Logging/Battery_Voltage", 0, "", 2,
    VIRTUAL_SIG, 0, 1, 2, 96, 0 },

  { 49, "vehicle_plant/NI_Display_and_Logging/Engine_rpm", 0, "", 3, VIRTUAL_SIG,
    0, 1, 2, 98, 0 },

  { 50, "vehicle_plant/NI_Display_and_Logging/Generator_Current", 0, "", 4,
    VIRTUAL_SIG, 0, 1, 2, 100, 0 },

  { 51, "vehicle_plant/NI_Display_and_Logging/Motor_Current", 0, "", 5,
    VIRTUAL_SIG, 0, 1, 2, 102, 0 },

  { 52, "vehicle_plant/NI_Display_and_Logging/Time", 0, "", 6, VIRTUAL_SIG, 0, 1,
    2, 104, 0 },

  { 53, "vehicle_plant/NI_Display_and_Logging/Vehicle_Speed_mph", 0, "", 7,
    VIRTUAL_SIG, 0, 1, 2, 106, 0 },

  { 54, "vehicle_plant/Generator_Torque", 0, "Generator_Torque", offsetof
    (ExternalInputs_Vehicle_Plant, Generator_Torque), EXTIO_SIG, 0, 1, 2, 108, 0
  },

  { 55, "vehicle_plant/Engine_On", 0, "Engine_On", offsetof
    (ExternalInputs_Vehicle_Plant, Engine_On), EXTIO_SIG, 0, 1, 2, 110, 0 },

  { 56, "vehicle_plant/Engine_Throttle", 0, "Engine_Throttle", offsetof
    (ExternalInputs_Vehicle_Plant, Engine_Throttle), EXTIO_SIG, 0, 1, 2, 112, 0
  },

  { 57, "vehicle_plant/Motor_torque_Request", 0, "Motor_Torque_Request",
    offsetof(ExternalInputs_Vehicle_Plant, Motor_Torque_Request), EXTIO_SIG, 0,
    1, 2, 114, 0 },

  { 58, "vehicle_plant/Brake_request", 0, "Brake_Request", offsetof
    (ExternalInputs_Vehicle_Plant, Brake_Request), EXTIO_SIG, 0, 1, 2, 116, 0 },

  { 59, "vehicle_plant/Battery_Connect_Command", 0, "Battery_Connect_Command",
    offsetof(ExternalInputs_Vehicle_Plant, Battery_Connect_Command), EXTIO_SIG,
    0, 1, 2, 118, 0 },

  { 60, "vehicle_plant/Gen_Enable", 0, "Gen_Enable", offsetof
    (ExternalInputs_Vehicle_Plant, Gen_Enable), EXTIO_SIG, 0, 1, 2, 120, 0 },

  { 61, "vehicle_plant/Motor_Enable", 0, "Motor_Enable", offsetof
    (ExternalInputs_Vehicle_Plant, Motor_Enable), EXTIO_SIG, 0, 1, 2, 122, 0 },

  { -1, "", -1, "", 0, 0, 0 }
};

static int NI_VirtualBlockSources[8][1] = { { 18 },

  { 19 },

  { 20 },

  { 21 },

  { 22 },

  { 23 },

  { 25 },

  { 24 } };

static int NI_VirtualBlockOffsets[8][1] = { { 0 },

  { 0 },

  { 0 },

  { 0 },

  { 0 },

  { 0 },

  { 0 },

  { 0 } };

static int NI_VirtualBlockLengths[8][1] = { { 1 },

  { 1 },

  { 1 },

  { 1 },

  { 1 },

  { 1 },

  { 1 },

  { 1 } };

static int NI_SigDimList[] = {
  1, 1, 1, 1, 1, 1, 1, 1, 1, 6, 1, 3, 1, 1, 1, 5, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 7, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1,
  1, 1,
  1, 1,
  1, 1,
  1, 1,
  1, 1,
  1, 1,
  1, 1,
};

static long NI_ExtListSize = 16;
static NI_ExternalIO NI_ExtList[] = {
  { 0, "Generator_Torque", 0, EXT_IN, 1, 1, 1 },

  { 1, "Engine_On", 0, EXT_IN, 1, 1, 1 },

  { 2, "Engine_Throttle", 0, EXT_IN, 1, 1, 1 },

  { 3, "Motor_torque_Request", 0, EXT_IN, 1, 1, 1 },

  { 4, "Brake_request", 0, EXT_IN, 1, 1, 1 },

  { 5, "Battery_Connect_Command", 0, EXT_IN, 1, 1, 1 },

  { 6, "Gen_Enable", 1, EXT_IN, 1, 1, 1 },

  { 7, "Motor_Enable", 1, EXT_IN, 1, 1, 1 },

  { 0, "Measured_Engine_rpm", 0, EXT_OUT, 1, 1, 1 },

  { 1, "Battery_SOC", 0, EXT_OUT, 1, 1, 1 },

  { 2, "Generator_Current_A", 0, EXT_OUT, 1, 1, 1 },

  { 3, "Battery_Pack_State", 1, EXT_OUT, 1, 1, 1 },

  { 4, "Motor_State", 0, EXT_OUT, 1, 1, 1 },

  { 5, "Gen_State", 0, EXT_OUT, 1, 1, 1 },

  { 6, "Motor_Current_A", 0, EXT_OUT, 1, 1, 1 },

  { 7, "Motor_rpm", 0, EXT_OUT, 1, 1, 1 },

  { -1, "", 0, 0, 0, 0, 0 }
};

/* This Task List is generated to allow access to the task specs without
 * initializing the model.
 * 0th entry is for scheduler (base rate)
 * rest for multirate model's tasks.
 */
NI_Task NI_TaskList[] = {
  { 0, 0.01, 0 }
};

int NI_NumTasks = 1;
int NIRT_ComputeNextCycleSampleHits(void)
{
  int retVal = 1+TID01EQ;              /* TID zero is always a sample hit, unless TID01EQ==1 */

#if defined(MULTITASKING)

  int i = 1;
  int tick, schedule_ticks;
  for (; i < NUMST-TID01EQ; ++i) {
    tick = S->Timing.TaskCounters.TID[i+TID01EQ] + 1;
    schedule_ticks = (int) ((NI_TaskList[i].tstep/NI_TaskList[0].tstep)+0.5);//Round to closest tick count
    if (tick == schedule_ticks)
      retVal |= (1 << (i+TID01EQ));
  }

#endif                                 /* defined(MULTITASKING) */

  return retVal;
}

static char* NI_CompiledModelName = "vehicle_plant";
static char* NI_CompiledModelVersion = "1.352";
static char* NI_CompiledModelDateTime = "Mon Sep 21 22:57:40 2009";

/* Model Information Query fucntions for MATLAB
 */
/* dll information
 * Returns 1 for RTW DLL
 *		   2 for AutoCode DLL
 */
DLL_EXPORT long NIRT_GetBuildInfo(char* detail, long* len)
{
  static char* builder = "9.0.0 SIT RTW Build";

  //There are no console properties to set for VxWorks, because the console is simply serial output data.
  //Just do printf for VxWorks and ignore all console properties.
#ifndef VXWORKS

  HANDLE hStdout = GetStdHandle(STD_OUTPUT_HANDLE);
  SetConsoleTextAttribute(hStdout, FOREGROUND_INTENSITY | FOREGROUND_BLUE |
    FOREGROUND_GREEN | FOREGROUND_RED);

#endif

  printf("\n*******************************************************************************\n");
  printf("%s\nModel Name: %s\nModel Version: %s\nCompiled On: %s",
         builder, NI_CompiledModelName, NI_CompiledModelVersion,
         NI_CompiledModelDateTime);
  printf("\n*******************************************************************************\n");

#ifndef VXWORKS

  SetConsoleTextAttribute(hStdout, FOREGROUND_BLUE | FOREGROUND_GREEN |
    FOREGROUND_RED);

#endif

  if (*len>=(long)strlen(builder))
    *len = strlen(builder)+1;
  strncpy(detail,builder,*len);
  return 1;
}

/*
 * Distinction between Index and ID:
 * Index is a long datatype (used to set parameter/probe signals).
 * ID on the other hand is a string (tag "2-3-2-12" for MatrixX/ Full path "f14/Gain/Gain" for Matlab).
 * NOTE: ID may not be the same as Paramname or signal name.
 */

/* signal information
   NOTE: signal ID == the blockname and port that feeds it.

   The port number in Simulation Environment is 1 indexed.. but on RT is 0 indexed.
 */
DLL_EXPORT long NIRT_GetSignalSpec(long* sidx, char* ID, long* ID_len, char
  * blkname, long *bnlen,
  long *portnum, char* signame, long *snlen, long *dattype, long* dims, long
  * numdim)
{
  long sigidx = *sidx;
  int i = 0;
  char *IDblk = 0;
  int IDport = 0;
  if (sigidx<0) {
    // check if ID has been specified.
    if (ID && *ID_len>0) {
      // parse ID into blkname and port
      i = strrchr(ID, ':') - ID;

      // malformed ID
      if (i<=0)
        return NI_SigListSize;
      ID[i] = 0;
      IDblk = ID;
      IDport = atoi(ID+i+1);

      // lookup the table for matching ID
      for (i=0;i<NI_SigListSize;i++) {
        if (!strcmp(IDblk,NI_SigList[i].blockname) && IDport==(NI_SigList[i].
             portno+1))
          break;
      }

      if (i<NI_SigListSize)
        sigidx = *sidx = i;
      else
        return NI_SigListSize;
    } else                             // no index or ID specified.
      return NI_SigListSize;
  }

  if (sigidx>=0 && sigidx<NI_SigListSize) {
    if (ID) {
      // no need for return string to be null terminated!
      // 10 to accomodate ':', port number and null character
      char *tempID = (char *)calloc(strlen(NI_SigList[sigidx].blockname) + 10,
        sizeof(char));
      sprintf(tempID,"%s:%d",NI_SigList[sigidx].blockname,NI_SigList[sigidx].
              portno+1);
      if ((long)strlen(tempID)<*ID_len)
        *ID_len = strlen(tempID);
      strncpy(ID, tempID, *ID_len);
      free(tempID);
    }

    if (blkname) {
      // no need for return string to be null terminated!
      if ((long)strlen(NI_SigList[sigidx].blockname)<*bnlen)
        *bnlen = strlen(NI_SigList[sigidx].blockname);
      strncpy(blkname, NI_SigList[sigidx].blockname, *bnlen);
    }

    if (signame) {
      // no need for return string to be null terminated!
      if ((long)strlen(NI_SigList[sigidx].signalname)<*snlen)
        *snlen = strlen(NI_SigList[sigidx].signalname);
      strncpy(signame, NI_SigList[sigidx].signalname, *snlen);
    }

    if (portnum)
      *portnum = NI_SigList[sigidx].portno;
    if (dattype)
      *dattype = NI_SigList[sigidx].datatype;
    if (dims && *numdim>=NI_SigList[sigidx].numofdims) {
      *numdim = NI_SigList[sigidx].numofdims;
      for (i=0;i < *numdim; i++)
        dims[i] = NI_SigDimList[NI_SigList[sigidx].dimListOffset +i];
    } else
      *numdim = 0;                     // set numdim to 0 to indicate that no enough memory to return the info.
    return 0;
  }

  return NI_SigListSize;
}

/*
 * Get parameter indices
 */
DLL_EXPORT long NIRT_GetParameterIndices(long* indices, long* len)
{
  long i;
  for (i=0;i<NI_ParamListSize && i<*len;i++)
    indices[i] = NI_ParamList[i].idx;
  *len = i;
  return NI_OK;
}

/*
 * parameter information
 *
 * if *pidx < 0, Lookup parameter by ID if ID != NULL.
 * if ID == NULL or no matching ID found, return number of parameters.
 *
 * plen  -> size of path
 * pnlen -> size of paramname
 * numdim -> size of dims array
 */
DLL_EXPORT long NIRT_GetParameterSpec(long* pidx, char* ID, long* ID_len, char
  * paramname, long *pnlen,
  long *dattype, long* dims, long* numdim)
{
  int i= 0;
  int paramidx = *pidx;
  if (paramidx<0) {
    // check if ID has been specified.
    if (ID && *ID_len>0) {
      // lookup the table for matching ID
      for (i=0;i<NI_ParamListSize;i++) {
        if (!strcmp(ID,NI_ParamList[i].paramname))
          break;
      }

      if (i<NI_ParamListSize)
        paramidx = *pidx = i;
      else
        return NI_ParamListSize;
    } else                             // no index or ID specified.
      return NI_ParamListSize;
  }

  if (paramidx>=0 && paramidx<NI_ParamListSize) {
    if (ID) {
      if ((long)strlen(NI_ParamList[paramidx].paramname)<*ID_len)
        *ID_len = strlen(NI_ParamList[paramidx].paramname);
      strncpy(ID, NI_ParamList[paramidx].paramname, *ID_len);
    }

    if (paramname) {
      // no need for return string to be null terminated!
      if ((long)strlen(NI_ParamList[paramidx].paramname)<*pnlen)
        *pnlen = strlen(NI_ParamList[paramidx].paramname);
      strncpy(paramname, NI_ParamList[paramidx].paramname, *pnlen);
    }

    if (dattype)
      *dattype = NI_ParamList[paramidx].datatype;
    if (!numdim)
      return 0;
    if (*numdim>=NI_ParamList[paramidx].numofdims) {
      *numdim = NI_ParamList[paramidx].numofdims;
      for (i=0;i < *numdim; i++)
        dims[i] = NI_ParamDimList[NI_ParamList[paramidx].dimListOffset +i];
    } else
      *numdim = 0;                     // set numdim to 0 to indicate that no enough memory to return the info.
    return 0;
  }

  return NI_ParamListSize;
}

/*
 * parameter expression information
 * If paramidx is outside of limit returns number of parameters, else 0.
 *
 * explen  -> size of expression
 */
DLL_EXPORT long NIRT_GetParameterExpression(long paramidx, char* expression,
  long *exp_len)
{
  if (paramidx>=0 && paramidx<NI_ParamListSize) {//If paramidx is valid then get expression
    if (expression && exp_len) {       //Make sure expression and exp_len are defined (don't point to NULL)
      if ((long)strlen(NI_ParamList[paramidx].expression)<*exp_len)
        *exp_len = strlen(NI_ParamList[paramidx].expression);
      strncpy(expression, NI_ParamList[paramidx].expression, *exp_len);//Copy string up to exp_len or actual expression length
    }

    return 0;
  }

  if (exp_len)
    *exp_len = 0;
  return NI_ParamListSize;
}

/*
 * variables information
 * If paramidx is outside of limit returns number of variables in list, else 0.
 *
 * varlen  -> size of variable name
 */
DLL_EXPORT long NIRT_GetVariableName(long varidx, char* variable_name, long
  *var_len)
{
  if (varidx>=0 && varidx<NI_VariablesListSize) {//If varidx is in valid range then get variable name
    if (variable_name && var_len) {    //Make sure variable name and var_len are defined (don't point to NULL
      if ((long)strlen(NI_VariablesList[varidx])<*var_len)
        *var_len = strlen(NI_VariablesList[varidx]);
      strncpy(variable_name, NI_VariablesList[varidx], *var_len);//Copy string up to var_len or actual variable length (which ever is shorter)
    }

    return 0;
  }

  if (var_len)
    *var_len = 0;
  return NI_VariablesListSize;
}

/*
 * NIRT_GetExtIOSpec
 *
 * Inputs:
 *		index: index of the task
 * Outputs:
 *		idx:  idx of the IO.
 *		name: Name of the IO block
 *		tid: task id
 *		type: EXT_IN or EXT_OUT
 *		dimX: size of 0th dimension
 *		dimY: size of 1th dimension
 * Return value: 0 if no error. (if index == -1, return number of tasks in the model)
 */
DLL_EXPORT long NIRT_GetExtIOSpec(long index, long *idx, char* name, long* tid,
  long *type, long *dims, long* numdims)
{
  if (index==-1)
    return NI_ExtListSize;
  if (idx)
    *idx = NI_ExtList[index].idx;
  if (name) {
    int sz = strlen(name);
    strncpy(name, NI_ExtList[index].name, sz-1);
    name[sz-1]= 0;
  }

  if (tid)
    *tid = NI_ExtList[index].TID;
  if (type)
    *type = NI_ExtList[index].type;
  if (numdims && dims) {
    if (*numdims>=2) {
      *numdims= 2;
      dims[0] = NI_ExtList[index].dimX;
      dims[1] = NI_ExtList[index].dimY;
    } else
      *numdims= 0;
  }

  return 0;
}

/* Helper function to probe one	signal. baseaddr must NOT be VIRTUAL_SIG */
static long NI_ProbeOneSignal(long idx, double *value, long len, long *count,
  long vOffset, long vLength)
{
  char *ptr = (char*)((NI_SigList[idx].baseaddr == BLOCKIO_SIG) ?
                      S->ModelData.blockIO : S->ModelData.inputs ) + (int)
    NI_SigList[idx].addr;
  long subindex = (vLength == -1) ? 0 : vOffset;
  long sublength = (vLength == -1) ? NI_SigList[idx].width : (vLength + vOffset);
  while ((subindex < sublength) && (*count < len))
    value[(*count)++] = NIRT_GetValueByDataType(ptr, subindex++, NI_SigList[idx]
      .datatype, NI_SigList[idx].IsComplex);
  return *count;
}

/*
 * NIRT_ProbeSignals
 *
 * Inputs:
 *		sigindices: indeces of signals
 *		numsigs: number of signals
 *		len: total length of all signals
 * Outputs:
 *		value: probed signal data
 *		len: length of data (may vary from input)
 * Return value: equal to len
 */
DLL_EXPORT long NIRT_ProbeSignals(long* sigindices, long numsigs,
  double* value, long* len)
{
  int i, j, count = 0, idx;
  if (!SITexportglobals.inCriticalSection)
    SetSITErrorMessage("SignalProbe should only be called between ScheduleTasks and PostOutputs",
                       1);
  if ((*len > 1) && (numsigs > 0)) {
    value[count++] = sigindices[0];
    value[count++] = 0;
  }

  for (i = 1; (i < numsigs) && (count < *len); i++) {
    idx = sigindices[i];
    if (idx < 0)
      break;
    if (idx < NI_SigListSize) {
      if (NI_SigList[idx].baseaddr == VIRTUAL_SIG) {
        for (j = 0; j < 1; j++) {
          long vidx = NI_VirtualBlockSources[NI_SigList[idx].addr][j];
          long voff = NI_VirtualBlockOffsets[NI_SigList[idx].addr][j];
          long vlen = NI_VirtualBlockLengths[NI_SigList[idx].addr][j];
          if (vidx == -1)
            break;
          NI_ProbeOneSignal(vidx, value, *len, &count, voff, vlen);
        }
      } else
        NI_ProbeOneSignal(idx, value, *len, &count, 0, -1);
    }
  }

  *len = count;
  return count;
}

/* Copy the	statically initialized params into our copy of the param struct
   The undef allows us to access the real Vehicle_Plant_P
   In the rest of the code Vehicle_Plant_P is redefine to be the read-side
   of rtParameter.
 */
#undef Vehicle_Plant_P

int NI_InitializeParamStruct()
{
  memcpy(&rtParameter[0], &Vehicle_Plant_P, sizeof(Parameters_Vehicle_Plant));
  return NI_OK;
}

/*  After the model has initialized and updated the parameters in
   rtParameter[0] (aka Vehicle_Plant_P) we make a copy to rtParameter[1] so
   that it is double buffered. We also do a memcpy to each task's copy.
 */
int NI_InitParamDoubleBuf()
{
  int idx = 1;

#ifdef MULTITASKING

  for (; idx <= NUMST - TID01EQ; idx++)
#endif

    memcpy(&rtParameter[idx], &rtParameter[0], sizeof(Parameters_Vehicle_Plant));
  return NI_OK;
}

static int NI_SetParamTxStatus = NI_OK;

// This function is called by the BGL to set parameters.  When a commit is requested (index < 0),
// the code enters a critical section shared with the TCL. This ensures that the flip occurs only
// when safe, and acts as a messaging scheme for us to copy back the parameters.
DLL_EXPORT long NIRT_SetParameter(long index, long subindex, double value)
{
  char* ptr = NULL;
  if (index>=NI_ParamListSize)
    return NI_SetParamTxStatus= NI_ERROR;
  if (index < 0) {
    if (NI_SetParamTxStatus==NI_ERROR) {
      // fail the transaction.
      // copy old	list of parameters to the failed TX buffer
      memcpy(&rtParameter[READSIDE], &rtParameter[1-READSIDE], sizeof
             (Parameters_Vehicle_Plant));

      // reset the status.
      NI_SetParamTxStatus = NI_OK;
      return NI_ERROR;
    }

    // commit changes
    S->ModelData.defaultParam = (double *)&rtParameter[1-READSIDE];
    WaitForSingleObject(SITexportglobals.flipCriticalSection, INFINITE);
    READSIDE = 1 - READSIDE;
    SITexportglobals.copyTaskBitfield = 0xFFFFFFFF;
    ReleaseSemaphore(SITexportglobals.flipCriticalSection, 1, NULL);

    // Copy back the newly set parameters to the writeside.
    memcpy(&rtParameter[1-READSIDE], &rtParameter[READSIDE], sizeof
           (Parameters_Vehicle_Plant));
    return NI_OK;
  }

  // verify that subindex is within bounds.
  if (subindex>=NI_ParamList[index].width)
    return NI_SetParamTxStatus= NI_ERROR;
  ptr = (char *)(&rtParameter[1-READSIDE]);
  ptr += (int)NI_ParamList[index].addr;
  return NIRT_SetValueByDataType(ptr,subindex,value,NI_ParamList[index].datatype,
    NI_ParamList[index].IsComplex);
}

DLL_EXPORT long NIRT_GetParameter(long index, long subindex, double *value)
{
  char* ptr = NULL;
  if (index>=NI_ParamListSize || index < 0)
    return NI_ERROR;

  // verify that subindex is within bounds.
  if (subindex>=NI_ParamList[index].width)
    return NI_ERROR;
  ptr = (char *)(&rtParameter[READSIDE]);
  ptr += (int)NI_ParamList[index].addr;
  *value = NIRT_GetValueByDataType(ptr,subindex,NI_ParamList[index].datatype,
    NI_ParamList[index].IsComplex);
  return NI_OK;
}

#endif                                 // of NI_ROOTMODEL_Vehicle_Plant
